#
#    ToolBus -- The ToolBus Application Architecture
#    Copyright (C) 1998-2000  Stichting Mathematisch Centrum, Amsterdam, 
#                             The  Netherlands.
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# -----------------------------------------------------------------------
# tb.perl -- fixed interface code for Perl <-> perl-adapter communication
#
# The structure of the Perl code used by the perl-adapter is as follows:
#	- copy of the users Perl script
#	- copy of tb.perl
#	- inline conditionals for checking existence of subroutines in
#	  the input signature
#	- the call
#	  	do TBcomm();
#	  starting the communication between Perl and perl-adapter
#
# -----------------------------------------------------------------------
# Predefined function that can be used freely in each Perl script:
#
# TBstring:     encode a Perl string into ToolBus format
# PERLstring:   decode a string in ToolBus format into Perl format
# TBsend:       send a Perl string to ToolBus
# TBerror:      wrap a Perl error message as TB message
# TBcomm:       start Perl <-> ToolBus communication
#               ``do TBcomm();'' is generated automatically at the end of
#		the Perl script by the perl-adapter
#------------------------------------------------------------------------

select(STDOUT); $| = 1;	# unbuffered standard output stream

select(STDERR); $| = 1; # unbuffered standard error stream

sub TBstring {
    local ($str) = @_;

    $res = "";

    while( $str =~ /(.*)\"(.*)$/ ) {
	$res = "res$1\\\"";
	$str = $2;
    }
    $res = "\"$res$str\"";
    return $res;
}

sub PERLstring {
    local($str) = @_;

    if( $str =~ /^\"(.*)\"$/ ){
	$str = $1;
    }
    return $str;
}

# The following function depends on
# LENSPEC = 8
# MIN_MSG_SIZE = 128
# (see utils.[ch])
# THIS SHOULD BE PARAMETERIZED !!!

sub TBsend {
    local($txt) = @_;
    $len = length($txt) + 12;
    $msg = sprintf("%-.11d:%s", $len,$txt);
    print STDOUT sprintf("%-128s", "$msg");
}

sub TBerror {
    local($txt) = @_;
    $txt = TBstring($txt);
    TBsend("perl_error($txt)");
}

sub main::TBcomm {
    while(<STDIN>){
#	print STDERR $_;
	eval($_);
	if($@ ne ""){
	  TBerror($@);
        }
    }
}

# generated by perl-adapter:
# do TBcomm();

#------------------- end-of: tb.perl -------------------------------



