.TH TRS_CHECK 1L "June 06, 1992" "UvA FWI" "PSF-Toolkit"
.UC 4
.SH NAME
trs_check \- check static semantics of a Term Rewrite System
.SH SYNOPSIS
.B trs_check
[
.B \-hv
] [
.I TIL-file
]
.SH DESCRIPTION
The
.B trs_check
program performs some checks regarding the static semantics of the term
rewriting system contained in a TIL-file.  If a problem is spotted,
an error message is printed.  Currently three classes of errors are found;
see the list in the DIAGNOSTICS section.
.LP
The
.B trs_check
program can be invoked implicitly by using the
.B \-t
option of
.BR psf (1L).
.SH OPTIONS
.TP
.B \-h
prints a usage message and exits.
.TP
.B \-v
prints a version number.
.SH DIAGNOSTICS
.TP
.BI "left hand side of equation [" tag "] is a variable."
It shouldn't be.
.TP
.BI "equation [" tag "]: variable " name " in right hand side not explicit.
Variables occuring on the right hand side of equations should also occur on
the left, or in the conditions.
.TP
.BI "equation [" tag "]: variable " name " in conditions not explicit.
The term rewrite tool
.BR trs (1L) 
requires that at least one side of each condition contains only variables
that also occur on the left hand side of the main equation, or in an earlier
condition.
.LP
The following PSF module contains examples of the three errors described above.
.in +1i
.nf

\fBdata\fP \fBmodule\fP Errors

\fBbegin\fP

  \fBsorts\fP
    S

  \fBfunctions\fP
    a : \-> S
    f : S \-> S

  \fBvariables\fP
    x,y,z : \-> S

  \fBequations\fP
    [ERROR1] x = a
    [ERROR2] f(x) = y
    [ERROR3] f(x) = a \fBwhen\fP z = y

\fBend\fP Errors

.fi
.in -1i
.SH SEE ALSO
.BR trs (1L),
.BR psf (1L).
.SH EXIT STATUS
The exit status returned by
.B trs_check
is the number of errors found.
This implies that a success code is returned if no errors were found.
.SH AUTHOR
Gert Veltink, University of Amsterdam (veltink@fwi.uva.nl)
