#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_fopen.h"
#include "psf_malloc.h"
#include "psf_standards.h"
#include "main.h"
#include "tiltype.h"
#include "readtil.h"
#include "env_variables.h"
#include "version.h"
#include "trs_check.h"

void usage()
{
    (void) fprintf(stderr, "usage: %s [-hv] [tilfile]\n", progname);
}

void version()
{
    (void) fprintf(stderr, "trs_check version %s, last compiled %s\n", VERSION,
				__DATE__);
}

extern int optind;
char *progname;
char *filename;

static int read_and_check(s, fp)
    char *s;
    FILE *fp;
{
    struct module mod;

    mod.name = psf_basename(s);
    if (read_module(&mod, fp)) {
	(void) fprintf(stderr, "%s: Error in input\n", progname);
	exit(1);
    }
    return trs_check(&mod);
}

int main(argc, argv)
    int argc;
    char *argv[];
{
    static suffix suffixes[] = {{TILSUFFIX, TILSUFFIX_DEFAULT}, {NULL, NULL}};
    FILE *input;
    int opt;
    psf_file pf;

    if (argc == 0) {
	(void) fprintf(stderr, "who am I?\n");
	exit(1);
    }
    progname = psf_basename(argv[0]);
    while ((opt = getopt(argc, argv, "hv")) != -1) {
	switch (opt) {
	case 'v':
	    version();
	    break;
	case 'h':
	    usage();
	    exit(0);
	case '?':
	    usage();
	    exit(1);
	}
    }

    switch (argc - optind) {
    case 0:
	filename = "stdin";
	return read_and_check("stdin", stdin);
    case 1:
	pf = psf_fopen(argv[optind], suffixes);
	input = pf.fp;
	filename = pf.name;
	return read_and_check(argv[optind], input);
    default:
	usage();
	exit(1);
    }

    return 0;	/* to shut up lint */
}
