/*
        utilities to manipulate transitions
*/

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "psf_malloc.h"

#include "tiltype.h"
#include "std.h"
#include "sign.h"
#include "objects.h"
#include "options.h"
#include "expressions.h"
#include "states.h"
#include "transitions.h"

void add_transition(source,label,target)
struct state *source,*target;
struct expression *label;
{
  struct transition *tmp;
  DLL tmp_list;

  if (Option_Debug || Option_Transitions) {
    printf("   --(");
    print_expression(label);
    printf(")--> ");
    print_state(target);
  }

  tmp = new_transition();

  tmp->label = label;
  tmp->target = target;

  dll_add(source->transitions,(DLL_INFO)tmp);

  if (label->type != EPS_EXP) {	/* this state is no longer in head nf */
    target->exp->nf = FALSE;
  } else {			/* epsilon path from ancestor to here */
    target->ancestor = source->ancestor;
  }

  tmp_list = target->expanded;
  target->expanded = dll_union(source->expanded,target->expanded);
  dll_dispose(tmp_list);
}

struct transition *new_transition()
{
  struct transition *tmp;

  tmp = PSF_MALLOC(struct transition);

  tmp->label = NULL;
  tmp->target = NULL;
  return(tmp);
}

int cmp_transitions(trans1,trans2)
DLL_INFO trans1,trans2;
{
  struct transition *t1,*t2;

  t1 = (struct transition *)trans1;
  t2 = (struct transition *)trans2;

  switch (sign(cmp_expressions(t1->label,t2->label))) {
    case ZERO:
      return(sign(t1->target->index - t2->target->index));
    case NEGATIVE:
      return(NEGATIVE);
      break;
    case POSITIVE:
      return(POSITIVE);
      break;
    default:
      ProgrammerError;
      break;
  }
  ProgrammerError;
  return(UNDEFINED);
}

void fprint_transition(file,source,label,target)
FILE *file;
struct state *source,*target;
struct expression *label;
{
  fprintf(file,"{S%d:",source->index);
  fprint_expression(file,source->exp);
  fprintf(file,"} --(");
  fprint_expression(file,label);
  fprintf(file,")--> {S%d:",target->index);
  fprint_expression(file,target->exp);
  fprintf(file,"}\n");
}

