.TH TRANS 1L "September 16, 1992" "UvA FWI" "PSF-Toolkit"
.UC 4
.SH NAME
trans \- labelled transition system generator
.SH SYNOPSIS
.B trans
[
.B \-bcdghlmrstvxz
] [
.B \-i
.I seed
] [
.IR inputfile
[
.IR outputfile
] ]
.SH DESCRIPTION
.B trans
transforms the PSF specification contained within its TIL input file
into a finite labelled transition system.  This labelled transition
system format is the required input format for
.B equiv
the bisimulation testing tool.  The operation of
.B trans
depends on the number of file arguments it is called with.
.TP 4n
.B trans
will take its input from the
.I standard input
and will write its output to the
.I standard output.
This is primarily useful when standard output is a pipe connecting
.B trans
to another program.
For example:
.sp
.in +1i
.B trans
<
.IB example .til
|
.B til_psf
.TP
.B trans \fIexample\fP.til
will take the file
.IB example .til
as input file and will write its output to the file
.IB example .lts.
An existing file with that name will be silently overwritten.
The suffix of the input file is checked to comply with the
.B TILSUFFIX
environment variable.  The default suffix
.IR .til
is used when
.B TILSUFFIX
is not set.  The suffix attached to the output file is specified in the
.B LTSSUFFIX
environment variable.  The default value of
.B LTSSUFFIX
is
.B .lts
.TP
.BI "trans " example ".til " example .out
Input is read from
.IB example .til .
As in the previous case, the suffix of the TIL file is checked.
The output is written to the file
.I example.out.
The suffix of the output file does not have to comply with the
.B LTSSUFFIX
environment variable, although adhering to this standard is advised.
.PP
The algorithm that generates the finite labelled transition system,
consists of several phases, which will each be shortly explained
below.
.TP 4n
1.  Reading the TIL file
The first phase consists of checking the input arguments and reading
the input file.  In this phase the program checks that the input
specification contains no actions or processes that contain data
parameters.  Furthermore the commutativity (and associativity) of the
communication function are checked and the communication function is
possibly extended in such a way that it becomes commutative and
associative (not yet actually).  Finally the definitions of possible
sets of atoms are evaluated.
.TP
2.  Checking guardedness
The next phase is optional and can be enabled using the
.B \-g
option to make sure that the input file contains a guarded
specification.
.TP
3.  State Generation
In the third phase, the program analyzes the process definitions and
starts generating states and transitions.  The calculation is performed
by interpreting the underlying process semantics of TIL as a term
rewrite system.  In this phase the transitions are labelled with atomic
actions, skips, or epsilon labels.  The latter indicates a silent
transition from the source to the target state.  This silent epsilon
transition should not be confused with the silent step from ACP or the
skip from PSF.  Unguarded specifications are detected in this phase,
and result in warning messages indicating the unguarded process
variables.  Execution will go on because unguarded specification are
not harmful.  Modifications to the process definitions, caused by
deletion of unreachable tail parts, are also performed in this phase.
These modifications are made visible if the
.B \-m
option is used.  In this phase the program also detects whether it is
not capable of generating a finite transition system.  If this is the
case it will generate an error message and will stop execution.  An
example of a recursive specification which can be represented by a
finite transition system, that nevertheless can not be generated by the
algorithm is:
.IR X =
.IR a .
.IR X .
.IR a  +  a
.TP
4.  Epsilon Closure
In the next phase the program calculates the epsilon closure of each
state, using the algorithm from Aho & Ullman [AU77].  The epsilon closure
.IR C(S)
of a state
.IR S
is defined as follows.  The state
.IR T
is an element of
.IR C(S)
, whenever from
.IR T
it is possible to do a non-epsilon transition, and
.I T
can be reached from
.IR S
through epsilon transitions only.
.TP
5.  Block Construction
In phase five, the epsilon closures generated in the previous phase are
sorted and assigned a so-called
.I block number.
Thereafter blocks are generated that consist of states with equal
epsilon closures.  All transitions are now updated to relate to blocks
instead of the original states.  The epsilon transitions have
disappeared now.  In fact the result of calculating the epsilon
closures and constructing the abovementioned blocks is, that in this
phase all epsilon transitions, are transitions from a block
.IR B
to itself, and can therefore safely be ignored in the sequel.
.TP
6.  Reachability Analysis
Phase six marks only those blocks that are reachable from the process
variables that appeared in the input file, and determines the
.I preferred representative
for a block among the states it consists of.  The representative is the
state generated at the earliest moment in time in phase three, unless
the block contains a state that is labelled with a process variable, in
which case the oldest of such states is chosen.  There is one more
exception.  There are exactly two blocks indicating termination of the
process, one for succesful termination and one for unsuccesful
termination.  They can be recognized by the fact that they contain the
state
.IR Final-State
and the state
.IR Deadlock-State
, respectively.  In these cases the preferred representative is either
.IR Final-State
or
.IR Deadlock-State.
.TP
7.  Generating Output
In the final phase the resulting transition system is written to the
output file.
.PP
.SH OPTIONS
.TP 4n
.B \-b
shows all the reachable blocks with their block number and the
expression defining the preferred representative of this block.  This
table is followed by a list of all transitions from reachable blocks,
sorted and indexed by their block number
.TP
.B \-c
gives extended information on the commutativity and associativity of
the communication function.  This option would normally be used to
trace the reason why the program cannot construct a commutative and
associative communication function from the
.IR communications
definition given in the specification.
.TP
.B \-d
shows debug information.  This is normally not of any interest, unless
one wants to take a look at the internal processing.
.TP
.B \-g
demands a guarded specification and checks this in advance.
Unguardedness of a specification is also detected during the state
generation phase of the algorithm.  If the
.B \-g
option is not used, the program will issue a warning, but will continue
operation.  The resulting transition system is not influenced by the
existence of a unguarded transition.  Such a transition is in fact an
epsilon transition from a state to itself, and is dealt with as such in
the epsilon closure phase of the algorithm.  The
.B \-g
option will however generate more comprehensive and complete error reports.
.TP
.B \-i \fIseed\fP
initializes the random generator based on the string
.IR seed .
The random generator is used by the trace generator invoked by the
.B \-x
option.
.TP
.B \-l
shows a list of all transitions from reachable blocks.  Each source and
target state are referred to by their block number and the preferred
representative.  For systems consisting of states represented by small
expressions this option is preferable to the
.B \-b
option.  In other cases output from this option tends to get messy.
.TP
.B \-m
shows the modifications that the program is performing on the process
expressions.  This always indicates that an unreachable tail part of a
process expression is being discarded.
.TP
.B \-r
shows the rewrites the program is applying to a process expression.
The output consists of a pair of lines.  The first line is a textual
representation of the rewrite rule applied.  This text is not generated
during the execution, but hard-wired into the source code.  The second
line shows how this rewrite rule affects the current process
expression.  For fanatics only.
.TP
.B \-s
invoke an ASCII menu based simulator after phase 2.  The simulator
produces a menu that lets the user pick an initial state, and then
searches for transitions from this state only.  After the transitions
have been found the epsilon closure is calculated for just this state,
and non-epsilon transitions from states in the epsilon closure are
added to the transitions of the current state.  Finally the epsilon
transitions leaving from the current state are discarded.  This results
in a significant improvement in execution speed.  When the simulator
hits a state it already has evaluated before, it will only have to
inspect its outgoing transitions.
.TP
.B \-t
shows all the transitions generated during the state generation phase,
as soon as they are encountered.  This information can be useful to
interpret the reported error message, when the program is not able to
generate a finite transition system.
.TP
.B \-v
puts the program in verbose mode.  In this mode the program gives an
indication of the phase it is working on.  Moreover, it shows the
version number, the name of the output file it is opening and the
number of states and transition in the transition system.
.TP
.B \-x
invoke an ASCII menu based trace generator after phase 2.  The
generator produces a menu that lets the user pick an initial state, and
then randomly generates a trace from that state, using the same
algorithm as the simulator invoked by the
.B \-s
option (q.v.).  The
.B \-x
option overrides the
.B \-s
option.
.TP
.B \-z
do not annotate transitions in the output file.  This reduces the size
of the file.  Currently, none of the tools uses these annotations.
.SH EXIT STATUS
.TP 4n
0       ERR_OK          no errors
.TP
1       ERR_PARAMETER   calling trans with illegal arguments
.TP
2       ERR_OPEN                file could not be opened
.TP
3       ERR_TIL         errors in TIL file
.TP
4       ERR_ARGUMENT    process or action has data arguments
.TP
5       ERR_INFINITE    no finite transition system could be generated
.TP
6       ERR_UNGUARDED   specification is unguarded
.TP
7       ERR_COMM_DEF    error in definition of communication function
.TP
8       ERR_SET         error in definition of sets
.TP
99      ERR_DLL         internal error from DLL Package
.SH ENVIRONMENT
.TP 15 n
.B TILSUFFIX
Suffix for a TIL input file.
.TP
.B LTSSUFFIX
Suffix for the generated labelled transition system.
.SH SEE ALSO
.LP
.BR psf (1L),
.BR til_psf (1L),
.BR sim (1L),
.BR equiv (1L).
.PP
.B [AU77]
A.V.  Aho & J.D.  Ullman,
.I Principles of Compiler Design,
Addison-Wesley, 1977.
.SH AUTHOR
Gert Veltink, University of Amsterdam (veltink@fwi.uva.nl)
.SH BUGS
The program currently fails to create an associative communication
function from the definitions given in the
.I communications
section.  A warning is issued when the communication function is not
associative.
.PP
The program can only handle specifications that contain no data
parameters for processes or atomic actions.
