#include "dll.h"


struct state {
  unsigned visited : 1;         /* visit mark for eps-closure search */
  unsigned deadlock : 1;        /* flag for deadlock state */
  unsigned final : 1;           /* flag for final state */
  unsigned non_epsilon : 1;     /* flag for non-epsilon transition  */
  unsigned explored : 1;	/* has this state been executed before? */
  struct expression *exp;       /* expression representing this state */
  int index;                    /* state index */
  int block;                    /* corresponding block index */
  int ancestor;                 /* epsilon path ancestor */
  DLL transitions;              /* list of outgoing transitions */
  DLL epsilon_closure;          /* epsilon closure of this state */
  DLL expanded;                 /* processes expanded to reach this state */
};

/* states.c */
extern DLL the_states;

extern int NR_TRANSITIONS;
extern int REACHABLE_TRANSITIONS;

extern void init_states PROTO_ARGS((void));
extern struct state *new_state PROTO_ARGS((void));
extern int new_state_index PROTO_ARGS((void));
extern void print_trans_for_states PROTO_ARGS((void));
extern void print_trans_for_state PROTO_ARGS((struct state *the_state));
extern void print_state PROTO_ARGS((struct state *state));
extern void fprint_state PROTO_ARGS((FILE *file, struct state *state));
extern void states_for_processes PROTO_ARGS((void));
extern int cmp_states PROTO_ARGS((DLL_INFO *s1, DLL_INFO *s2));
extern int non_epsilon_transitions PROTO_ARGS((struct state *state));
