/*
        utilities to manipulate states
*/

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "psf_malloc.h"

#include "tiltype.h"
#include "exitcodes.h"
#include "options.h"
#include "objects.h"
#include "expressions.h"
#include "sign.h"
#include "definitions.h"
#include "transitions.h"
#include "states.h"
#include "statetrees.h"

DLL the_states;

int NR_TRANSITIONS;
int REACHABLE_TRANSITIONS;

void init_states()
{
  the_states = dll_create();
}

struct state *new_state()
{
  struct state *tmp;

  tmp = PSF_MALLOC(struct state);

  tmp->exp = NULL;
  tmp->index = new_state_index();
  tmp->block = UNDEFINED;
  tmp->ancestor = UNDEFINED;
  tmp->transitions = dll_su_create(cmp_transitions);
  tmp->epsilon_closure = dll_su_create(cmp_states);
  tmp->visited = FALSE;
  tmp->deadlock = FALSE;
  tmp->final = FALSE;
  tmp->non_epsilon = FALSE;
  tmp->visited = FALSE;
  tmp->explored = FALSE;
  tmp->expanded = dll_s_create(cmp_integers);

  dll_append(the_states,(DLL_INFO)tmp);

  return(tmp);
}

int new_state_index()
{
  static int curr_state=0;

  return(++curr_state);
}

void print_trans_for_states()
{
  DLL_ITEM state_ptr;
  struct state *the_state;

  DLL_FORALL(the_states,state_ptr) {
    the_state = (struct state *)dll_inspect(state_ptr);
    print_trans_for_state(the_state);
  }
}

void print_trans_for_state(the_state)
struct state *the_state;
{
  DLL_ITEM trans_ptr;
  struct transition *the_transition;

  print_state(the_state);
  /*
  printf("has non-epsilon transitions %d\n",
  				non_epsilon_transitions(the_state));
  */
  DLL_FORALL(the_state->transitions,trans_ptr) {
    the_transition = (struct transition *)dll_inspect(trans_ptr);
    printf("S%d -(",the_state->index);
      print_expression(the_transition->label);
    printf(")-> S%d : ",the_transition->target->index);
    print_expression(the_transition->target->exp);
    printf("\n");
  }
  printf("\n");
}

void print_state(state)
struct state *state;
{
  printf("state %d : ",state->index);
  print_expression(state->exp);
  printf("\n");

}

void fprint_state(file,state)
FILE *file;
struct state *state;
{
  fprint_expression(file,state->exp);
  fprintf(file,"\n");
}

void states_for_processes()
{
  int i;

  for_all_processes(i) {
    process[i]->initial = expr_to_state(process[i]->myself);
    if (Option_Debug) {
      print_state(process[i]->initial);
    }
  }
}

int cmp_states(s1,s2)
DLL_INFO *s1,*s2;
{
  return(sign(((struct state *)(s1))->index - ((struct state *)(s2))->index));
}

int non_epsilon_transitions(state)
struct state *state;
{
  DLL_ITEM ptr;
  struct transition *the_transition;

  DLL_FORALL(state->transitions,ptr) {
    the_transition = (struct transition*)dll_inspect(ptr);
    if (the_transition->label->type != EPS_EXP) {
      return(TRUE);
    }
  }
  return(FALSE);
}

