#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/types.h>
#include "psf_prototype.h"
#include "psf_redefs.h"
#include "random.h"

/*
	randomization routines:
		void srandstr(char *seed);
		void srandtime(void);
		int randbnd(int lower, int upper);

*/

/*
	SYNOPSIS:
		#include "random.h"
		void srandstr(char *seed);

	DESCRIPTION:
		the srandstr function takes a string as argument and computes
		an integer seed for srand from this string.
		Subsequently srand48() is called with this calculated seed.

	RETURNS
		no value returned
*/

/*
	Changes:
		Use s?random() instead of s?rand(): as the man page points out,
		the low order bits of the return value of rand() are cyclic.
		HansM	23/02/93

		But the s?random funtions are available only with the BSD
		version of the C library, so they are not available with
		every compiler: use [ls]rand48 like the simulator does.
		Mark 6/8/93
*/

void srandstr(seed)
char *seed;
{
  long the_seed;

  for (the_seed = 0; *seed != '\0'; seed++) {
    the_seed = *seed + 31 * the_seed;
  }

  srand48(the_seed);
}


/*
	SYNOPSIS:
		#include "random.h"
		void srandtime(void);

	DESCRIPTION:
		the function srandtime calculates an integer seed for the
		pseudo random generator using function time.
		Subsequently srand48() is called with this calculated seed.

	RETURNS
		no value returned
*/

void srandtime()
{
  srand48((long)time((time_t*)NULL));
}


/*
	SYNOPSIS:
		#include "random.h"
		void randbnd(int lower, int upper);

	DESCRIPTION:
		the function randbnd returns an integer between the lower
		and upper boundary.

	RETURNS
		a pseudo random integer in the range lower to upper.
		0 if an invalid range was given
*/

int randbnd(lower,upper)
int lower,upper;
{
  if (upper < lower) {
    return(0);
  }
  return(lower + (lrand48() % (upper-lower+1)));
}
