#include <stdio.h>
#include "psf_prototype.h"
#include "psf_standards.h"

#include "exitcodes.h"
#include "main.h"
#include "options.h"

/* options */

int Option_Verbose = FALSE;
int Option_Debug = FALSE;
int Option_Transitions = FALSE;
int Option_List = FALSE;
int Option_Modifications = FALSE;
int Option_Guardedness = FALSE;
int Option_Blocks = FALSE;
int Option_Communication = FALSE;
int Option_Simulator = FALSE;
int Option_Rewrite = FALSE;
int Option_Execution = FALSE;
int Option_Stripped = FALSE;

char *Option_Initial_Seed = NULL;
extern char *optarg;
void process_options(argc,argv)
int argc;
char *argv[];
{
  int opt;

  while ((opt = getopt(argc,argv,OPTIONS)) != -1) {
    switch (opt) {
      case 'b':
	Option_Blocks = TRUE;
	break;
      case 'c':
	Option_Communication = TRUE;
	break;
      case 'd':
	Option_Debug = TRUE;
	break;
      case 'g':
	Option_Guardedness = TRUE;
	break;
      case 'h':
	usage();
	break;
      case 'i':
	Option_Initial_Seed = optarg;
	break;
      case 'l':
	Option_List = TRUE;
	break;
      case 'm':
	Option_Modifications = TRUE;
	break;
      case 'r':
	Option_Rewrite = TRUE;
	break;
      case 's':
	Option_Simulator = TRUE;
	break;
      case 't':
	Option_Transitions = TRUE;
	break;
      case 'v':
	Option_Verbose = TRUE;
	break;
      case 'x':
	Option_Execution = TRUE;
	break;
      case 'z':
 	Option_Stripped = TRUE;
 	break;
      case '?':
	usage();
	exit(ERR_PARAMETER);
    }
  }
}
