/*
        utilities to generate til output file
*/

#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "tiltype.h"
#include "fieldex.h"
#include "exitcodes.h"
#include "options.h"
#include "objects.h"
#include "expressions.h"
#include "definitions.h"
#include "states.h"
#include "transitions.h"
#include "blocks.h"
#include "lts_til.h"

int *til_translation;

void til_indexes()
{
  int i,til_index=0;

  til_translation = PSF_NMALLOC(int,REACHABLE_BLOCKS);

  for (i=0; i<NR_BLOCKS; i++) {
    if (the_block[i].reachable) {
      til_translation[til_index++] = i;
      the_block[i].til_index = til_index;
    }
  }
}

void write_til_file(mod,fp)
struct module *mod;
FILE *fp;
{
  int i,def_cnt,generated;
  DLL_ITEM trans_ptr;
  struct transition *the_transition;

  for (i=1; i<=mod->entries_table[ADM]; i++) {
    fprintf(fp,"[%d.%d]\t\t{ %s }\n",ADM,i,mod->adm[i].ff);
  }

  generated=i++;
  fprintf(fp,"[%d.%d]\t\t{ <m>%d %s }\n",ADM,generated,generated,
		"-generated-by-trans");

  fprintf(fp,"[%d.%d]\t\t{ <states>%d <transitions>%d }\n",
		ADM,i,REACHABLE_BLOCKS,REACHABLE_TRANSITIONS);

  for (i=1; i<=NR_ATOMS; i++) {
    fprintf(fp,"[%d.%d]\t0\t{ <n>%s <o>%s }\n",
		ATM,i,atom[i]->name,field_extract("o",mod->atm[i].ff,ATM,i));
  }

  for (i=0; i<REACHABLE_BLOCKS; i++) {

    fprintf(fp,"[%d.%d]\t0\t{ <n>",PRO,i+1);

    if (the_block[til_translation[i]].name) {
      fprintf(fp,"%s",the_block[til_translation[i]].name);
      switch (the_block[til_translation[i]].exp->type) {
	case PRC_EXP:
	  fprintf(fp," <o>%s",field_extract("o",
			mod->pro[the_block[til_translation[i]].exp->index].ff,
			PRO,the_block[til_translation[i]].exp->index));
	  break;
	case DLK_EXP:
	case TCK_EXP:
	  fprintf(fp," <o>%d",generated);
	  break;
      }
    } else {
      fprintf(fp,"State-%d <o>%d",i+1,generated);
    }
    if (!Option_Stripped) {
      fprintf(fp," <r>\"");
      fprint_expression(fp,the_block[til_translation[i]].exp);
      fprintf(fp,"\"");
    }
    fprintf(fp," }\n");
  }

  def_cnt = 1;

  for (i=0; i<NR_BLOCKS; i++) {
    if (the_block[i].reachable) {
      DLL_FORALL (the_block[i].transitions,trans_ptr) {
	the_transition = (struct transition *)dll_inspect(trans_ptr);
	if (the_transition->label->type == SKP_EXP) {
	  fprintf(fp,"[%d.%d]\t[%d.%d] = <seq,2>(<skip> [%d.%d])\t{",
	  DEF,def_cnt++,PRO,the_block[i].til_index,
	  PRO,the_block[the_transition->target->block].til_index);
	} else {
	  fprintf(fp,"[%d.%d]\t[%d.%d] = <seq,2>([%d.%d] [%d.%d])\t{",
	  DEF,def_cnt++,PRO,the_block[i].til_index,
	  ATM,the_transition->label->index,
	  PRO,the_block[the_transition->target->block].til_index);
	}
	if (!Option_Stripped) {
	  fprintf(fp," <t>\"");
	  fprint_expression(fp,the_block[i].exp);
	  fprintf(fp," -(");
	  fprint_expression(fp,the_transition->label);
	  fprintf(fp,")-> ");
	  fprint_expression(fp,
	    the_block[the_transition->target->block].exp);
	  fprintf(fp,"\" }\n");
	} else {
	  fprintf(fp,"}\n");
	}
      }
    }
  }
}
