/*
    *** interface.h: User Interface Routines ***
*/

#ifndef User_Interface_Available
#define User_Interface_Available

#include "dll.h"

/*
    User Interface Types
*/

typedef FILE	    *UI_VIEWPORT;
typedef char	    *UI_DIALOG;
typedef int	    UI_CODE;

/*
    User Interface Constants
*/

#define UI_ILLEGAL_INPUT    (-1)
#define UI_CANCEL	    (-2)
#define UI_KEY		    (-3)    /* user selected characterkey */

#define UI_KEYBOARD	    stdin   /* somewhat crude, we agree */
#define UI_CONSOLE	    stderr  /* somewhat crude, some more */
#define UI_BUF_SIZE	    128

/*
    Menu Specific Types
*/

typedef DLL	    MENU;	    /* list of items to be shown in menu */
typedef DLL_ITEM    MENU_PTR;	    /* pointer to items in menu */
typedef DLL_INFO    MENU_ITEM;	    /* contents of menu */
typedef int	    MENU_INDEX;	    /* index of choice in menu */
typedef void	    (*MENU_DISPLAY) (); /* display function for MENU_ITEMs */
typedef char	    *MENU_OPTIONS;  /* option characters */

/*
    User Interface Globals
*/

/* interface.c */
extern UI_CODE UI_LATEST_KEY;
extern UI_CODE UI_LATEST_CODE;
extern MENU_ITEM menu_select PROTO_ARGS((UI_VIEWPORT viewport, MENU menu, MENU_DISPLAY print_item, UI_DIALOG caption, UI_DIALOG explain, MENU_OPTIONS options));
extern MENU_INDEX range_select PROTO_ARGS((UI_VIEWPORT viewport, MENU_INDEX min, MENU_INDEX max, MENU_OPTIONS options));

#endif
