/*
    *** interface.c: User Interface Routines ***
*/

#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_standards.h"

#include "exitcodes.h"
#include "interface.h"
#include "main.h"
#include "std.h"

UI_CODE UI_LATEST_KEY;
UI_CODE UI_LATEST_CODE;

/*
    arguments for selection routine:

    UI_VIEWPORT	    viewport:	    output channel
    MENU	    menu:	    list of items to be selected
    MENU_DISPLAY    print_item:	    function to print item from the list.
    UI_DIALOG	    caption:	    the message shown to the user at the top
    UI_DIALOG	    explain:	    message explaining extra keys
    MENU_OPTIONS    options:	    character set specifying legal keys


    RETURN:	pointer to chosen MENU_ITEM
		or appropriate UI_CODE
 */

MENU_ITEM menu_select(viewport,menu,print_item,caption,explain,options)
UI_VIEWPORT viewport;
MENU	    menu;
MENU_DISPLAY	print_item;
UI_DIALOG   caption;
UI_DIALOG   explain;
MENU_OPTIONS	options;
{
  MENU_INDEX index, choice;
  MENU_PTR ptr;

  fprintf(viewport,"%s\n",caption);

  index = 0;
  DLL_FORALL (menu,ptr) {
    fprintf(viewport,"%3d. ",++index);
    (*(print_item))(viewport,(MENU_ITEM)dll_inspect(ptr));
    fprintf(viewport,"\n");
  }
  fprintf(viewport,"%s\n",explain);

  choice = range_select(viewport,1,index,options);

  switch (UI_LATEST_CODE) {

    case UI_CANCEL:
    case UI_KEY:
      return(NULL);
      break;

    default:
      index = 0;
      DLL_FORALL (menu,ptr) {
	if ((++index) == choice) {
	  return((MENU_ITEM)dll_inspect(ptr));
	}
      }
      break;
  }

  ProgrammerError;
  return(NULL);
}

/*
    arguments for range routine:

    file:	output channel
    min:	minimum for range (inclusive)
    max:	maximum for range (inclusive)

    RETURN:	value	    within range
		UI_CANCEL   user cancelled operation
*/

MENU_INDEX range_select(viewport,min,max,options)
UI_VIEWPORT	viewport;
MENU_INDEX	min,max;
MENU_OPTIONS	options;
{
  MENU_INDEX choice;
  char input_buffer[UI_BUF_SIZE];   /* buffer for user input */
  char conversion_char;		/* variable for internal conversion */

  do {
    fprintf(viewport,"your choice: ");

    switch(fscanf(UI_KEYBOARD,"%s",input_buffer)) {
    case EOF:
      fprintf(viewport,"\n");
      exit(ERR_OK);
      break;
    default:
      /* ERROR */
      choice = UI_ILLEGAL_INPUT;
      break;
    case 1:
      if (sscanf(input_buffer,"%d",&choice) != 1) {
	if (sscanf(input_buffer,"%1c",&conversion_char) != 1) {
	  choice = UI_ILLEGAL_INPUT;
	} else {
	  if (conversion_char == '#') {
	    choice = UI_CANCEL;
	  } else {
	    if (strchr(options,conversion_char) != NULL) {
	      UI_LATEST_KEY = conversion_char;
	      choice = UI_KEY;
	    } else {
	      choice = UI_ILLEGAL_INPUT;
	    }
	  }
	}
      } else {
	if ((choice < min) || (choice > max)) {
	  choice = UI_ILLEGAL_INPUT;
	}
      }
      break;
    }

    if (choice != UI_ILLEGAL_INPUT) {
      UI_LATEST_CODE = choice;
      return(choice);
    }

  } while (TRUE);

  ProgrammerError;
  return(FALSE);
}
