/*
        create head normal forms for PSF expressions
*/

#include <stdio.h>
#include <assert.h>
#include "psf_prototype.h"
#include "psf_standards.h"

#include "tiltype.h"
#include "expressions.h"
#include "definitions.h"
#include "exitcodes.h"
#include "states.h"
#include "head_nf.h"
#include "main.h"
#include "objects.h"
#include "options.h"
#include "sign.h"
#include "std.h"

static int deadlock_or_double = 0;

/*
static void println_expression(expr)
  struct expression *expr;
{
  print_expression(expr);
  printf("\n");
}
*/

/*
	rewrite structure of expression
*/

#define ONE_PHASE 1
#define USE_NF 1

struct expression *head_nf_state(state,expansion)
struct state *state;
int expansion;
{
  int cmp;
  struct expression *rew_expr;
  struct mode the_mode;

  the_mode.expansion = expansion;
  the_mode.head = FALSE;
  the_mode.tail = FALSE;
  the_mode.finite = FALSE;

#if 0
  printf("head_nf_state: ");
  print_expression(state->exp);
  printf("\n");
#endif	/* 0 */

  rew_expr = head_nf(state->exp,state,the_mode);

  if (cmp = sign(cmp_expressions(state->exp,rew_expr))) {

    if (Option_Debug) {
      print_expression(state->exp);
      printf(" rewritten into ");
      print_expression(rew_expr);
      printf("\n");
    }

    if (cmp < 0) {
      if (Option_Debug || Option_Verbose) {
	printf("\nNorm of expression increased while reducing??\n");
	printf("Are we heading for an infinite loop?\n");
	print_expression(state->exp);
	printf(" rewritten into ");
	print_expression(rew_expr);
	printf("\n");
      }
      if (Option_Debug) {
	fprintf(stdout,"###########\n");
	fprint_parse_tree(stdout,state->exp);
	fprintf(stdout,"**********\n");
	fprint_parse_tree(stdout,rew_expr);
	printf("\n");
      }
    }
  }

#define BOOM 1

#if BOOM
  if (cmp < 0) {
    print_expression(state->exp);
    printf(" rewritten into ");
    print_expression(rew_expr);
    printf("\n");
    fprintf(stdout,"###########\n");
    fprint_parse_tree(stdout,state->exp);
    fprintf(stdout,"**********\n");
    fprint_parse_tree(stdout,rew_expr);
  }
  assert(0 <= cmp);
#endif	/* BOOM */

#if !ONE_PHASE
#define DEBUG_PHASE_2 0

#if DEBUG_PHASE_2
  list_alternatives(rew_expr);

  printf("into del_dbl: ");
  print_expression(rew_expr);
#endif	/* DEBUG_PHASE_2 */

  rew_expr = delete_doubles(rew_expr);

  if (rew_expr->type == ALT_EXP) {
    if (rew_expr->right->type == DLK_EXP) {
      rew_expr = rew_expr->right;
    }
  }

#if DEBUG_PHASE_2
  printf("\nout of del_dbl: ");
  print_expression(rew_expr);
  printf("\n");
#endif	/* DEBUG_PHASE_2 */
#endif	/* !ONE_PHASE */

  return(rew_expr);
}

void list_alternatives(expr)
struct expression *expr;
{
  int cnt=0;

  printf("listing alternatives: \n");
  while (expr->type == ALT_EXP) {
    printf("*** %2d.\n",++cnt);
    fprint_parse_tree(stdout,expr->right);
    printf("\n");
    expr = expr->left;
  }
  printf("*** %2d.\n",++cnt);
  fprint_parse_tree(stdout,expr);
  printf("listing alternatives ready! \n");
}

/* delete doublures in an alternative composition, postprocessor for head_nf */

struct expression *delete_doubles(expr)
struct expression *expr;
{
  struct expression *l_op,*r_op;

  switch (expr->type) {
    case ATM_EXP:
    case PRC_EXP:
    case DLK_EXP:
    case TCK_EXP:
    case EPS_EXP:
    case SKP_EXP:
      return(expr);
      break;

    case ALT_EXP:
      l_op = delete_doubles(expr->left);
      r_op = delete_doubles(expr->right);

      if (cmp_expressions(l_op,r_op) == ZERO) {
	TRS("x + x -> x");
	return(l_op);
      }

      if (l_op->type == DLK_EXP) {
	TRS("<delta> + x -> x");
	return(r_op);
      }

      if (r_op->type == DLK_EXP) {
	TRS("x + <delta> -> x");
	return(l_op);
      }

      return(update_expression(expr,l_op,r_op,expr->type));
      break;

    case SEQ_EXP:
    case PAR_EXP:
    case COM_EXP:
    case LMG_EXP:
      l_op = delete_doubles(expr->left);
      r_op = delete_doubles(expr->right);
      return(update_expression(expr,l_op,r_op,expr->type));
      break;

    case HID_EXP:
    case ENC_EXP:
      r_op = delete_doubles(expr->right);
      return(update_expression(expr,expr->left,r_op,expr->type));
      break;

  }
  print_expression(expr);
  ProgrammerError;
  return 0;		/* to shut up lint */
}

#define TRACE_REWRITE 1
#if TRACE_REWRITE	/* show trace information of the current rewrite */
struct expression *head_nf_calc();

struct expression *head_nf(expr,state,mode)
struct expression *expr;
struct state *state;
struct mode mode;
{
  static int depth = 0;
  int i;
  struct expression *tmp;

  if (Option_Debug) {
    printf("%2d. ",depth);
    for (i=0; i<depth; i++) {
      printf("  ");
    }
    printf("?: ");
    print_expression(expr);
    printf("\n");

    depth++;
  }

#if USE_NF
  if (mode.expansion < expr->nf) {	/* don't rewrite normal forms */
#if 0
    printf("don't rewrite: [%d/%d] ",mode.expansion+1,expr->nf);
    print_expression(expr);
    printf("\n");
#endif	/* 0 */
    tmp = expr;
  } else {
#endif	/* USE_NF */

    tmp = head_nf_calc(expr,state,mode);

#if USE_NF
    if (tmp->nf < 1 + mode.expansion) {
      tmp->nf = 1 + mode.expansion;
    }
  }
#endif	/* USE_NF */

  if (Option_Debug) {
    depth--;

    printf("%2d. ",depth);
    for (i=0; i<depth; i++) {
      printf("  ");
    }
    switch (sign(cmp_expressions(expr,tmp))) {
      case NEGATIVE:
	printf("@: ");
	break;
      case ZERO:
	printf("!: ");
	break;
      case POSITIVE:
	printf("#: ");
	break;
    }
    print_expression(expr);
    printf(" --> ");
    print_expression(tmp);
    printf("\n");
  }

#define SHOW_PROGRESS 0
#if SHOW_PROGRESS
  switch (sign(cmp_expressions(expr,tmp))) {
    case NEGATIVE:
      putchar('<');
      break;
    case POSITIVE:
      putchar('>');
      break;
    case ZERO:
      putchar('=');
      break;
  }
#endif	/* SHOW_PROGRESS */

#define SHOW_SHAKY 0
#if SHOW_SHAKY
  switch (sign(cmp_expressions(expr,tmp))) {

    case NEGATIVE:
      if (!deadlock_or_double) {
	fprintf(stderr,"%s: ****** Rewrite Error ******\n",progname);
	fprint_parse_tree(stderr,expr);
	fprintf(stderr," --> ");
	fprint_parse_tree(stderr,tmp);
	fprintf(stderr,"%s: ****** End of Rewrite Error ******\n",progname);
      } else {
	deadlock_or_double--;
      }
      break;

#if 0
    case POSITIVE:
      fprintf(stderr,"#: ");
      fprint_expression(stderr,expr);
      fprintf(stderr," --> ");
      fprint_expression(stderr,tmp);
      fprintf(stderr,"\n");
      break;
#endif	/* 0 */
  }
#endif	/* SHOW_SHAKY */

  if (Option_Rewrite) {

    switch (sign(cmp_expressions(expr,tmp))) {
      case NEGATIVE:
	printf("@: ");
	print_expression(expr);
	printf(" --> ");
	print_expression(tmp);
	printf("\n");
	break;
      case ZERO:
	break;
      case POSITIVE:
	printf("#: ");
	print_expression(expr);
	printf(" --> ");
	print_expression(tmp);
	printf("\n");
	break;
    }
  }

  return(tmp);
}

struct expression *head_nf_calc(expr,state,mode)
#else	/* TRACE_REWRITE */
struct expression *head_nf(expr,state,mode)
#endif	/* TRACE_REWRITE */
struct expression *expr;
struct state *state;
struct mode mode;
{
  struct expression *l_op,*r_op;
  struct expression *x,*y,*z;
  struct expression *tmp,*top;
  struct mode new_mode,no_expansion_mode;

#if 0
  printf("head_nf: [%d/%d] ",mode.expansion+1,expr->nf);
  print_expression(expr);
  printf("\n");
#endif	/* 0 */

  no_expansion_mode = mode;		/* copy the current mode */
  no_expansion_mode.expansion = FALSE;	/* but leave out expansion bit */

  switch (expr->type) {

    case ATM_EXP:
    case SKP_EXP:
    case DLK_EXP:
    case TCK_EXP:
      return(expr);

    case PRC_EXP:
      if (mode.expansion) {
	if (!mode.head) {
	  if (process[expr->index]->expansion == EXPANDING) {
	    fprintf(stderr,"\n%s: Warning: unguarded expression.\n",progname);
	    fprintf(stderr,"    process variable '");
	    fprint_expression(stderr,expr);
	    fprintf(stderr,"' in : ");
	    fprint_expression(stderr,state->exp);
	    fprintf(stderr,"\n");
	    return(expr);
	  }
	  if (mode.tail) {
	    if (mode.finite) {
	      if (dll_search(state->expanded,(DLL_INFO)expr->index)) {
		fprintf(stderr,
			"\n%s: Warning: probably infinite transition system.\n",
			progname);
		fprintf(stderr,"    illegal non-tail recursion of '");
		fprint_expression(stderr,expr);
		fprintf(stderr,"' in : ");
		fprint_expression(stderr,state->exp);
		fprintf(stderr,"\n    execution halted!\n");
		exit(ERR_INFINITE);
	      }
	    }
	  }
	}
	dll_add(state->expanded,(DLL_INFO)expr->index);
	process[expr->index]->expansion = EXPANDING;
	tmp = head_nf(process[expr->index]->exp,state,mode);
	process[expr->index]->expansion = EXPANDED;
	return(tmp);
      } else {
	return(expr);
      }

      break;

    case ALT_EXP:

      /* x + y */

#define MONITOR_ALT 0
#if MONITOR_ALT
      fprintf(stderr,"%s: the term in alt: ",progname);
      fprint_expression(stderr,expr);
      fprintf(stderr,"\n");
#endif	/* MONITOR_ALT */

      l_op = head_nf(expr->left,state,mode);
      r_op = head_nf(expr->right,state,mode);

#if MONITOR_ALT
      fprintf(stderr,"%s: the left operand: ",progname);
      fprint_expression(stderr,l_op);
      fprintf(stderr,"\n");
      fprintf(stderr,"%s: the right operand: ",progname);
      fprint_expression(stderr,r_op);
      fprintf(stderr,"\n");
#endif	/* MONITOR_ALT */

#if ONE_PHASE
      if (l_op->type == DLK_EXP) {
	TRS("<delta> + x -> x");
	deadlock_or_double++;
	return(r_op);
      }

      if (r_op->type == DLK_EXP) {
	TRS("x + <delta> -> x");
	deadlock_or_double++;
	return(l_op);
      }
#endif	/* ONE_PHASE */

      switch(sign(cmp_expressions(l_op,r_op))) {
	case ZERO:

#if ONE_PHASE
	  TRS("x + x -> x");
	  deadlock_or_double++;
	  return(l_op);		/* could as well be return(r_op); */
	  break;
#endif	/* ONE_PHASE */
	case NEGATIVE:
	  TRS("x + y -> x + y  when x < y");
	  break;
	case POSITIVE:
	  TRS("x + y -> y + x  when x > y");
	  swap_expressions(&l_op,&r_op);
	  break;
      }
      /* Assertion: l_op, r_op = hnf & l_op < r_op */

      if (r_op->type == ALT_EXP) {
	TRS("x + (y + z) -> (x + y) + z)");

	x = l_op;
	y = r_op->left;
	z = r_op->right;
	l_op = create_expression(ALT_EXP,x,y);
	l_op = head_nf(l_op,state,mode);
	r_op = z;
      }

      if (l_op->type == ALT_EXP) {
	/* (x + y) + z -> ... */

	x = l_op->left;
	y = l_op->right;
	z = r_op;

	switch (sign(cmp_expressions(y,z))) {
	  case ZERO:
#if ONE_PHASE
	    TRS("(x + y) + z -> x + y  when y = z");
	    deadlock_or_double++;
	    return(l_op);
	    break;
#endif	/* ONE_PHASE */
	  case NEGATIVE:
	    TRS("(x + y) + z -> (x + y) + z  when y < z");
	    return(update_expression(expr,l_op,r_op,ALT_EXP));
            break;
	  case POSITIVE:
	    TRS("(x + y) + z -> (x + z) + y  when y > z");
	    l_op = create_expression(ALT_EXP,x,z);
	    r_op = y;
	    top = create_expression(ALT_EXP,l_op,r_op);
	    return(head_nf(top,state,mode));
	    break;
	}
      }
      return(update_expression(expr,l_op,r_op,ALT_EXP));
      break;

    case SEQ_EXP:

      /* x . y */

      if (!finite_trace_exp(expr->left)) {
	TRS("x . y -> x  when x not finite");
	if (Option_Modifications) {
	  printf("*** transforming: ");
	  print_expression(expr);
	  printf(" into ");
	  print_expression(expr->left);
	  printf("\n");
	}
	return(head_nf(expr->left,state,mode));
      }

      new_mode = mode;
      new_mode.expansion = FALSE;		/* no expansion of rhs */
      new_mode.head = TRUE;			/* rhs has a guard */
      r_op = head_nf(expr->right,state,new_mode);

      new_mode = mode;
      new_mode.tail = TRUE;			/* we have tail now */
      new_mode.finite = finite_trace_exp(r_op);	/* is it finite? */
      l_op = head_nf(expr->left,state,new_mode);

      switch (l_op->type) {

	case DLK_EXP:
	  TRS("<delta> . x -> <delta>");
	  return(deadlock);
	  break;

	case SEQ_EXP:
	  TRS("(x . y) . z -> x . (y . z)");
	  x = l_op->left;
	  y = l_op->right;
	  z = r_op;
	  l_op = x;
	  r_op = create_expression(SEQ_EXP,y,z);
	  top = create_expression(SEQ_EXP,l_op,r_op);
	  return(head_nf(top,state,mode));
	  break;

	case ALT_EXP:
	  if (mode.expansion) {
	    TRS("(x + y) . z -> (x . z) + (y . z)");
	    x = l_op->left;
	    y = l_op->right;
	    z = r_op;
	    l_op = create_expression(SEQ_EXP,x,z);
	    r_op = create_expression(SEQ_EXP,y,z);
	    top = create_expression(ALT_EXP, l_op, r_op);
	    return(head_nf(top,state,no_expansion_mode));
	  }
	  break;
      }

      return(update_expression(expr, l_op, r_op, SEQ_EXP));
      break;

    case PAR_EXP:

      l_op = head_nf(expr->left,state,no_expansion_mode);
      r_op = head_nf(expr->right,state,no_expansion_mode);

#if ONE_PHASE
      if (l_op->type == DLK_EXP) {
	TRS("<delta> || x -> x . <delta>");
	deadlock_or_double++;
        tmp = create_expression(SEQ_EXP,r_op,deadlock);
        return(head_nf(tmp,state,mode));
      }

      if (r_op->type == DLK_EXP) {
	TRS("x || <delta> -> x . <delta>");
	deadlock_or_double++;
        tmp = create_expression(SEQ_EXP,l_op,deadlock);
        return(head_nf(tmp,state,mode));
      }
#endif	/* ONE_PHASE */

      if (mode.expansion) {
	TRS("x || y -> x ||_ y + y ||_ x + x | y");
	tmp = create_expression(LMG_EXP,head_nf(l_op,state,mode),r_op);
	top = create_expression(LMG_EXP,head_nf(r_op,state,mode),l_op);
	tmp = create_expression(ALT_EXP,tmp,top);
	top = create_expression(COM_EXP,l_op,r_op);
	top = create_expression(ALT_EXP,tmp,top);

	return(head_nf(top,state,no_expansion_mode));
      }

      switch(sign(cmp_expressions(l_op,r_op))) {
	case ZERO:
	case NEGATIVE:
	  TRS("x || y -> x || y  when x <= y");
	  break;
	case POSITIVE:
	  TRS("x || y -> y || x  when x > y");
	  swap_expressions(&l_op,&r_op);
	  break;
      }

      if (r_op->type == PAR_EXP) {
	TRS("x || (y || z) -> (x || y) || z)");
	x = l_op;
	y = r_op->left;
	z = r_op->right;
	l_op = create_expression(PAR_EXP,x,y);
	l_op = head_nf(l_op,state,mode);
	r_op = z;
      }

      if (l_op->type == PAR_EXP) {
	/* (x || y) || z -> ... */

	x = l_op->left;
	y = l_op->right;
	z = r_op;

	switch (sign(cmp_expressions(y,z))) {

	  case ZERO:
	  case NEGATIVE:
	    TRS("(x || y) || z -> (x || y) || z  when y <= z ");
            break;
	  case POSITIVE:
	    TRS("(x || y) || z -> (x || z) || y  when y > z ");
	    tmp = create_expression(PAR_EXP,x,z);
	    top = create_expression(PAR_EXP,tmp,y);
	    return(head_nf(top,state,no_expansion_mode));
	    break;
	}
      }

      return(update_expression(expr,l_op,r_op,PAR_EXP));
      break;

    case LMG_EXP:

      /* x ||_ y */

      l_op = head_nf(expr->left,state,mode);
      r_op = head_nf(expr->right,state,no_expansion_mode);

      if (l_op->type == DLK_EXP) {
	TRS("<delta> ||_ x -> <delta>");
	return(deadlock);
      }

#if ONE_PHASE
      if (r_op->type == DLK_EXP) {
	TRS("x ||_ <delta> -> x . <delta>");
	deadlock_or_double++;
        tmp = create_expression(SEQ_EXP,l_op,deadlock);
        return(head_nf(tmp,state,no_expansion_mode));
      }
#endif	/* ONE_PHASE */

      if (mode.expansion) {
	switch (l_op->type) {

	  case ATM_EXP:
	    TRS("a ||_ x -> a . x");
	    return(create_expression(SEQ_EXP,l_op,r_op));
	    break;

	  case SKP_EXP:
	    TRS("<skip> ||_ x -> <skip> . x");
	    return(create_expression(SEQ_EXP,l_op,r_op));
	    break;

	  case ALT_EXP:
	    TRS("(x + y) ||_ z -> (x ||_ z) + (y ||_ z)");
	    x = l_op->left;
	    y = l_op->right;
	    z = r_op;
	    l_op = create_expression(LMG_EXP,x,z);
	    r_op = create_expression(LMG_EXP,y,z);
	    top = create_expression(ALT_EXP, l_op, r_op);
	    return(head_nf(top,state,mode));
	    break;

	  case SEQ_EXP:
	    TRS("(x . y) ||_ z -> x . (y || z)  when x in {atom, <skip>, <delta>}");

	    switch (l_op->left->type) {

	      case ATM_EXP:
	      case SKP_EXP:
	      case DLK_EXP:
		break;

	      default:
		ProgrammerError;
		break;
	    }

	    x = l_op->left;
	    y = l_op->right;
	    z = r_op;

            tmp = create_expression(PAR_EXP,y,z);
	    return(create_expression(SEQ_EXP,x,tmp));
	    break;

	  default:
	    ProgrammerError;
	    break;
	}
      }

      if (l_op->type == LMG_EXP) {
	TRS("(x ||_ y) ||_ z) -> x ||_ (y || z)");
	x = l_op->left;
	y = l_op->right;
	z = r_op;
        tmp = create_expression(PAR_EXP,y,z);
        return(create_expression(LMG_EXP,x,tmp));
      }

      return(update_expression(expr,l_op,r_op,LMG_EXP));
      break;

    case COM_EXP:

      /* x | y */

#define LOUD_COM 0

#if LOUD_COM
      printf("com_exp starting to rewrite: ");
      print_expression(expr);
      printf("\n");
#endif	/* LOUD_COM */

      l_op = head_nf(expr->left,state,mode);

#if LOUD_COM
      printf("com_exp the left: ");
      print_expression(l_op);
      printf("\n");
#endif	/* LOUD_COM */

      r_op = head_nf(expr->right,state,mode);

#if LOUD_COM
      printf("com_exp the right: ");
      print_expression(r_op);
      printf("\n");
#endif	/* LOUD_COM */

      if ( l_op->type == DLK_EXP ) {
	TRS("<delta> | x -> <delta>");
	return(deadlock);
      }

      if ( r_op->type == DLK_EXP ) {
	TRS("x | <delta> -> <delta>");
	return(deadlock);
      }

      if ( l_op->type == SKP_EXP ) {
	TRS("<skip> | x -> <delta>");
	return(deadlock);
      }

      if ( r_op->type == SKP_EXP ) {
	TRS("x | <skip> -> <delta>");
	return(deadlock);
      }

      switch(sign(cmp_expressions(l_op,r_op))) {
	case ZERO:
	case NEGATIVE:
	  TRS("x | y -> x | y  when x <= y");
	  break;
	case POSITIVE:
	  TRS("x | y -> y | x  when x > y");
	  swap_expressions(&l_op,&r_op);
	  break;
      }

      if (r_op->type == COM_EXP) {
	TRS("x | (y | z) -> <delta>");
	return deadlock;
      }

      if (l_op->type == COM_EXP) {
	TRS("(x | y) | z -> <delta>");
	return deadlock;
      }

      if (mode.expansion) {
	struct expression *head, *tail, *left, *right;
  	int comm;

	if (l_op->type == ALT_EXP) {
	    TRS("(x + y) | z -> (x | z) + (y | z)");
	    x = l_op->left;
	    y = l_op->right;
	    z = r_op;
	    left = create_expression(COM_EXP,x,z);
	    right = create_expression(COM_EXP,y,z);
	    top = create_expression(ALT_EXP,left,right);
	    return(head_nf(top,state,mode));
	}

	if (r_op->type == ALT_EXP) {
	    TRS("x | (y + z) -> (x | y) + (x | z)");
	    x = l_op;
	    y = r_op->left;
	    z = r_op->right;
	    left = create_expression(COM_EXP,x,y);
	    right = create_expression(COM_EXP,x,z);
	    top = create_expression(ALT_EXP,left,right);
	    return(head_nf(top,state,mode));
	}

	switch (l_op->type) {
	  case ATM_EXP:
	    switch (r_op->type) {
	      case ATM_EXP:
		TRS("a | b -> <gamma>(a,b)");
		comm = communication(l_op->index, r_op->index);
		if (comm == NO_COMMUNICATION) {
		  return(deadlock);
		} else {
		  top = new_expression();
		  top->type = ATM_EXP;
		  top->index = comm;
		  return(top);
		}
		break;

	      case SEQ_EXP:
		TRS("a | b . x -> <gamma>(a,b) . x");
		comm = communication(l_op->index, r_op->left->index);
		if (comm == NO_COMMUNICATION) {
		  return(deadlock);
		} else {
		  head = new_expression();
		  head->type = ATM_EXP;
		  head->index = comm;
		  tail = head_nf(r_op->right,state,no_expansion_mode);
		  return(create_expression(SEQ_EXP,head,tail));
		}
		break;

	      default:
		ProgrammerError;
	    }
	    break;

	  case SEQ_EXP:
	    switch (r_op->type) {
	      case ATM_EXP:
		TRS("a . x | b -> <gamma>(a,b) . x");
		comm = communication(l_op->left->index, r_op->index);
		if (comm == NO_COMMUNICATION) {
		  return(deadlock);
		} else {
		  head = new_expression();
		  head->type = ATM_EXP;
		  head->index = comm;
		  tail = head_nf(l_op->right,state,no_expansion_mode);
		  return(create_expression(SEQ_EXP,head,tail));
		}
		break;

	      case SEQ_EXP:
		TRS("a . x | b . y -> <gamma>(a,b) . (x || y)");
		comm = communication(l_op->left->index, r_op->left->index);
		if (comm == NO_COMMUNICATION) {
		  return(deadlock);
		} else {
		  head = new_expression();
		  head->type = ATM_EXP;
		  head->index = comm;
		  tail = create_expression(PAR_EXP,l_op->right,r_op->right);
		  tail = head_nf(tail,state,no_expansion_mode);
		  return(create_expression(SEQ_EXP,head,tail));
		}
		break;

	      default:
		ProgrammerError;
	    }
	    break;

	  default:
	    ProgrammerError;
	}
      }

      return(update_expression(expr,l_op,r_op,COM_EXP));
      break;

    case ENC_EXP:

      /* encaps(H, x) */

      /*
      printf("encapsulation working on: ");
      print_expression(expr);
      printf("\n");
      */

      l_op = expr->left;
      r_op = head_nf(expr->right,state,mode);

      /*
      printf("encapsulation's argument after first rewriting: ");
      print_expression(r_op);
      printf("\n");
      */

      switch (r_op->type) {

	case SKP_EXP:
	  TRS("enc(H, <skip>) -> <skip>");
	  return(r_op);
	  break;

	case DLK_EXP:
	  TRS("enc(H, <delta>) -> <delta>");
	  return(r_op);
	  break;

	case ATM_EXP:
	  /* enc(H,a) -> ... */
	  if (dll_search(set_contents(l_op),(DLL_INFO)r_op->index)) {
	    TRS("enc(H, a) -> <delta>  when a in H");
	    return(deadlock);
	  } else {
	    TRS("enc(H, a) -> a  when a not in H");
	    return(r_op);
	  }
	  break;

	case SEQ_EXP:
	/* enc(H, x . y) -> ...  x in {action,deadlock,skip} */

	  x = r_op->left;
	  y = r_op->right;

	  switch (x->type) {

	    case ATM_EXP:
	      if (dll_search(set_contents(l_op),(DLL_INFO)x->index)) {
		TRS("enc(H, a . x) -> <delta>  when a in H");
		return(deadlock);
	      } else {
		TRS("enc(H, a . x) -> x . enc(H, x)  when a not in H");
		tmp = clone_expression(expr);
		tmp->right = y;
		tmp = head_nf(tmp,state,no_expansion_mode);
		return(create_expression(SEQ_EXP,x,tmp));
	      }
	      break;

	    case DLK_EXP:
	      TRS("enc(H, <delta> . x) -> <delta>");
	      return(deadlock);
	      break;

	    case SKP_EXP:
	      TRS("enc(H, <skip> . x) -> <skip> . enc(H, x) ");
	      tmp = clone_expression(expr);
	      tmp->right = y;
	      tmp = head_nf(tmp,state,no_expansion_mode);
	      return(create_expression(SEQ_EXP,x,tmp));
	      break;

	    default:
	      printf("rewrite: unanticipated type (%d)\n",x->left->type);
	      printf("operator name: %s\n",operator_name[x->left->type]);
	      ProgrammerError;
	      break;
	  }

	case ALT_EXP:
	  TRS("enc(H, x + y) -> enc(H, x) + enc(H, y)  when expansion needed");
	  if (mode.expansion) {

            x = r_op->left;
	    y = r_op->right;

	    l_op = clone_expression(expr);
	    l_op->right = x;
	    l_op = head_nf(l_op,state,mode);

	    r_op = clone_expression(expr);
	    r_op->right = y;
	    r_op = head_nf(r_op,state,mode);

	    top = create_expression(ALT_EXP,l_op,r_op);
	    return(head_nf(top,state,no_expansion_mode));
	  }
	  break;

        case ENC_EXP:
          /* enc(H1, enc(H2, X)) -> ... */

	  switch (sign(expr->index - r_op->index)) {

	    case ZERO:
	      TRS("enc(H1, enc(H2, x)) -> enc(H2, x)  when H1 = H2");
	      return(r_op);
	      break;

	    case NEGATIVE:
	      TRS("enc(H1, enc(H2, x)) -> enc(H1, enc(H2, x))  when H1 < H2");
	      break;

	    case POSITIVE:
	      TRS("enc(H1, enc(H2, x)) -> enc(H2, enc(H1, x))  when H1 > H2");
	      tmp = clone_expression(expr);	/* enc(H1, ...) */
	      top = clone_expression(r_op);	/* enc(H2, ...) */
	      tmp->right = r_op->right;
	      tmp = head_nf(tmp,state,no_expansion_mode);
	      top->right = tmp;
	      return(top);
	      break;
	  }
	  break;

        case PAR_EXP:
        case LMG_EXP:
        case COM_EXP:
        case HID_EXP:
        case PRC_EXP:
	  break;

	default:
	  printf("rewrite: unanticipated type (%d)\n",x->type);
	  printf("operator name: %s\n",operator_name[x->type]);
	  ProgrammerError;
	  break;
      }

      return(update_expression(expr,l_op,r_op,ENC_EXP));
      break;

    case HID_EXP:

      /* hide(I, x) */

      /*
      printf("abstraction working on: ");
      print_expression(expr);
      printf("\n");
      */

      l_op = expr->left;
      r_op = head_nf(expr->right,state,mode);

      /*
      printf("abstraction's argument after first rewriting: ");
      print_expression(r_op);
      printf("\n");
      */

      switch (r_op->type) {

	case SKP_EXP:
	  TRS("hide(I, <skip>) -> <skip>");
	case DLK_EXP:
	  TRS("hide(I, <delta>) -> <delta>");
	  return(r_op);
	  break;

	case ATM_EXP:
	  /* hide(I,a) -> ... */
	  if (dll_search(set_contents(l_op),(DLL_INFO)r_op->index)) {
	    TRS("hide(I, a) -> <skip>  when a in I");
	    return(skip);
	  } else {
	    TRS("hide(I, a) -> a  when a not in I");
	    return(r_op);
	  }
	  break;

	case SEQ_EXP:
	/* hide(I, x.y) -> ...  x in {action,deadlock,skip} */

	  if (mode.expansion) {
	    x = r_op->left;
	    y = r_op->right;

	    switch (x->type) {

	      case ATM_EXP:
		if (dll_search(set_contents(l_op),(DLL_INFO)x->index)) {
		  TRS("hide(I, a.x) -> <skip> . x  when a in I");
		  tmp = clone_expression(expr);
		  tmp->right = y;
		  tmp = head_nf(tmp,state,no_expansion_mode);
		  return(create_expression(SEQ_EXP,skip,tmp));
		} else {
		  TRS("hide(I, a.x) -> a . hide(I, x)  when a not in I");
		  tmp = clone_expression(expr);
		  tmp->right = y;
		  tmp = head_nf(tmp,state,no_expansion_mode);
		  return(create_expression(SEQ_EXP,x,tmp));
		}
		break;

	      case DLK_EXP:
		TRS("hide(I, <delta> . x) -> <delta>");
		return(deadlock);
		break;

	      case SKP_EXP:
		TRS("hide(I, <skip> . x) -> <skip> . hide(I, x) ");
		tmp = clone_expression(expr);
		tmp->right = y;
		tmp = head_nf(tmp,state,no_expansion_mode);
		return(create_expression(SEQ_EXP,x,tmp));
		break;

	      default:
		printf("rewrite: unanticipated type (%d)\n",x->type);
		printf("operator name: %s\n",operator_name[x->type]);
		ProgrammerError;
		break;
	    }
	  }

	case ALT_EXP:
	  if (mode.expansion) {
	    TRS("hide(I, x + y) -> hide(I, x) + hide(I, y)");

            x = r_op->left;
	    y = r_op->right;

	    l_op = clone_expression(expr);
	    l_op->right = x;
	    l_op = head_nf(l_op,state,mode);

	    r_op = clone_expression(expr);
	    r_op->right = y;
	    r_op = head_nf(r_op,state,mode);

	    top = create_expression(ALT_EXP,l_op,r_op);
	    return(head_nf(top,state,no_expansion_mode));
	  }
	  break;

        case HID_EXP:
	  /* hide(I1, hide(I2, X)) -> ... */

	  switch (sign(expr->index - r_op->index)) {

	    case ZERO:
	      TRS("hide(I1, hide(I2, x)) -> hide(I2, x)  when I1 = I2");
	      return(r_op);
	      break;

	    case NEGATIVE:
	      TRS("hide(I1, hide(I2, x)) -> hide(I1, hide(I2, x))  when I1 < I2");
	      return(expr);
	      break;

	    case POSITIVE:
	      TRS("hide(I1, hide(I2, x)) -> hide(I2, hide(I1, x))  when I1 > I2");
	      tmp = clone_expression(expr);	/* hide(I1, ...) */
	      top = clone_expression(r_op);	/* hide(I2, ...) */
	      tmp->right = r_op->right;
	      tmp = head_nf(tmp,state,no_expansion_mode);
	      top->right = tmp;
	      return(top);
	      break;
	  }
	  break;

        case PAR_EXP:
        case LMG_EXP:
        case COM_EXP:
        case ENC_EXP:
        case PRC_EXP:
	  break;

	default:
	  printf("rewrite: unanticipated type (%d)\n",x->type);
	  printf("operator name: %s\n",operator_name[x->type]);
	  ProgrammerError;
	  break;
      }

      return(update_expression(expr,l_op,r_op,HID_EXP));
      break;

    default:
      printf("rewrite: unanticipated type (%d)\n",expr->type);
      printf("operator name: %s\n",operator_name[expr->type]);
      ProgrammerError;
      break;

  }

  ProgrammerError;
  return(NULL);
}
