/*
	constants used to represent the different types of expressions
*/

#define ALT_EXP 0		/* alternative composition */
#define DLK_EXP 1 		/* deadlock */
#define PAR_EXP 2 		/* parallel composition */
#define ATM_EXP 3		/* atom action */
#define SKP_EXP 4		/* skip / tau */
#define EPS_EXP 5		/* epsilon */
#define TCK_EXP 6 		/* succesful termination */
#define SEQ_EXP 7 		/* sequential composition */
#define HID_EXP 8  		/* abstraction */
#define ENC_EXP 9 		/* encapsulation */
#define LMG_EXP 10		/* left merge */
#define COM_EXP 11		/* communication merge */
#define PRC_EXP 12		/* process variable */
#define NR_EXPS 13		/* total number of expression types */

struct expression {
  int type;                     /* type of this node */
  int index;                    /* probable index in process or atom table */
  struct expression *left;      /* left operand */
  struct expression *right;     /* right operand */
  int nf;                       /* is this sub-tree in normal form? */
};

/* expressions.c */
extern struct expression the_epsilon;
extern struct expression *epsilon;
extern struct expression the_tick;
extern struct expression *tick;
extern struct expression the_deadlock;
extern struct expression *deadlock;
extern struct expression the_skip;
extern struct expression *skip;
extern struct expression *new_expression PROTO_ARGS((void));
extern struct expression *create_expression PROTO_ARGS((int type, struct expression *left, struct expression *right));
extern struct expression *clone_expression PROTO_ARGS((struct expression *prototype));
extern struct expression *update_expression PROTO_ARGS((struct expression *expr, struct expression *left, struct expression *right, int type));
extern void fprint_identifier_exp PROTO_ARGS((FILE *file, struct expression *expr));
extern void fprint_identifier PROTO_ARGS((FILE *file, int type, int index));
extern void swap_expressions PROTO_ARGS((struct expression **px, struct expression **py));
extern int cmp_expressions PROTO_ARGS((struct expression *exp1, struct expression *exp2));
extern struct expression *copy_expression PROTO_ARGS((struct expression *expr));
extern void print_it PROTO_ARGS((struct expression *expr));
extern void fprint_expression PROTO_ARGS((FILE *file, struct expression *expr));
extern void fprint_parse_depth PROTO_ARGS((FILE *file));
extern void fprint_operator PROTO_ARGS((FILE *file, int operator));
extern void fprint_parse_tree PROTO_ARGS((FILE *file, struct expression *expr));
extern struct expression *retrieve_expression PROTO_ARGS((struct process_expr *pexp));
extern struct expression *read_expression PROTO_ARGS((int index));

#define print_identifier(x,y) fprint_identifier(stdout,x,y)
#define print_identifier_exp(x) fprint_identifier(stdout,x)
#define print_expression(x) fprint_expression(stdout,x)
