/*
        utilities to manipulate states
*/

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "tiltype.h"
#include "expressions.h"
#include "definitions.h"
#include "exitcodes.h"
#include "states.h"
#include "expand.h"
#include "head_nf.h"
#include "main.h"
#include "objects.h"
#include "options.h"
#include "statetrees.h"
#include "transitions.h"

void expand_states()
{
  DLL_ITEM ptr;
  struct state *the_state;

  DLL_FORALL(the_states,ptr) {
    the_state = (struct state *)dll_inspect(ptr);
    expand_state(the_state);
  }
}

void expand_state(state)
struct state *state;
{
  struct expression *the_expr;
  struct state *tmp_state;

  if (Option_Debug || Option_Transitions) {
    printf("\n");
    print_state(state);
  }

  /*
  if (state->index == 107) {
    Option_Rewrite = TRUE;
  }
  */

  the_expr = head_nf_state(state,TRUE);	/* expansion needed */

  switch(the_expr->type) {

    case DLK_EXP:	/* no expansion of deadlock */
      add_transition(state,epsilon,expr_to_state(deadlock));
      break;

    case TCK_EXP:	/* no expansion of final state */
      break;

    case ATM_EXP:
    case SKP_EXP:	/* skip acts in this case like an atom */
      add_transition(state,the_expr,expr_to_state(tick));
      break;

    case ALT_EXP:
      while (the_expr->type == ALT_EXP) {
	add_transition(state,epsilon,expr_to_state(the_expr->right));
	the_expr = the_expr->left;
      }
      add_transition(state,epsilon,expr_to_state(the_expr));
      break;

    case SEQ_EXP:
      switch (the_expr->left->type) {
	case SKP_EXP:
	case ATM_EXP:
	  tmp_state = expr_to_state(the_expr->right);
	  if (Option_Debug) {
	    printf("Expression: ");
	    print_expression(the_expr->right);
	    printf(" =>  state ");
	    print_expression(tmp_state->exp);
	    printf("\n");
	  }
	  add_transition(state,the_expr->left,expr_to_state(the_expr->right));
	  break;
	case DLK_EXP:
	  add_transition(state,epsilon,expr_to_state(deadlock));
	  break;

	default:
	  printf("expand_state: unanticipated type of state\n");
	  printf("operator name: %s\n",operator_name[the_expr->left->type]);
	  assert(0);
	  abort();
	  break;
      }
      break;

    default:
      add_transition(state,epsilon,expr_to_state(the_expr));
      break;
  }
}

#if 0
void illegal_recursion_error(expr,ancestor)
struct expression *expr,*ancestor;
{
  fprintf(stderr,
	"\n%s: Warning: probably infinite transition system.\n",progname);
  fprintf(stderr,"    illegal non-tail recursion of '");
  fprint_expression(stderr,expr);
  fprintf(stderr,"' in : ");
  fprint_expression(stderr,ancestor);
  fprintf(stderr,"\n    Execution Halted!\n");
  exit(ERR_INFINITE);
}
#endif
