/*
        _dll.h : include file with private functions


*/

#include "dll.h"

#define LIST_ID 13579		/* magic number to identify list */
#define ITEM_ID 24680		/* magic number to identify item */
#define FREED_LIST_ID 97531	/* magic number to identify freed list */
#define FREED_ITEM_ID 8642	/* magic number to identify freed item */





#if DLL_CHECK
/* dll_check.c */
extern void check_item PROTO_ARGS((DLL_ITEM item));
extern void check_list PROTO_ARGS((DLL list));
extern void check_non_empty_list PROTO_ARGS((DLL list));
extern void check_order_fns PROTO_ARGS((DLL x, DLL y));
extern void check_non_sorted PROTO_ARGS((DLL list));
extern void check_on_list PROTO_ARGS((DLL list, DLL_ITEM item));
extern void check_list_types PROTO_ARGS((DLL x, DLL y));
extern int cmp_pointers PROTO_ARGS((DLL_INFO *p1, DLL_INFO *p2));
#endif

/* _DLL_FORALL: make a for loop traversing all elements from l using p as ptr */
#define _DLL_FORALL(l,p) for(p=_dll_go_first(l);p!=NULL;p=_dll_go_fw(p))


/* private no checking functions */

extern DLL_ITEM _dll_create_item PROTO_ARGS((DLL_INFO info));
extern DLL_INFO _dll_delete_item PROTO_ARGS((DLL list, DLL_ITEM ptr));
extern void _dll_dispose_item PROTO_ARGS((DLL_ITEM ptr));
extern DLL _dll_create_descendent PROTO_ARGS((DLL prototype));
extern void _dll_flush PROTO_ARGS((DLL ptr));
extern void _dll_dispose PROTO_ARGS((DLL ptr));
extern int _dll_empty PROTO_ARGS((DLL list));
extern int _dll_first PROTO_ARGS((DLL list, DLL_ITEM curr));
extern int _dll_last PROTO_ARGS((DLL list, DLL_ITEM curr));
extern int _dll_count PROTO_ARGS((DLL list));
extern DLL _dll_copy PROTO_ARGS((DLL list));
extern DLL_ITEM _dll_go_first PROTO_ARGS((DLL list));
extern DLL_ITEM _dll_go_last PROTO_ARGS((DLL list));
extern DLL_ITEM _dll_go_fw PROTO_ARGS((DLL_ITEM curr));
extern DLL_ITEM _dll_go_bw PROTO_ARGS((DLL_ITEM curr));
extern DLL_ITEM _dll_add PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_ITEM _dll_insert PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_ITEM _dll_append PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_ITEM _dll_add_before PROTO_ARGS((DLL list, DLL_ITEM curr, DLL_INFO info));
extern DLL_ITEM _dll_add_after PROTO_ARGS((DLL list, DLL_ITEM curr, DLL_INFO info));
extern DLL_ITEM _dll_add_first PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_ITEM _dll_add_last PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_ITEM _dll_insert_at PROTO_ARGS((DLL list, DLL_ITEM curr, DLL_INFO info));
extern DLL_ITEM _dll_append_at PROTO_ARGS((DLL list, DLL_ITEM curr, DLL_INFO info));
extern DLL_INFO _dll_delete PROTO_ARGS((DLL list, DLL_ITEM curr));
extern DLL_INFO _dll_delete_first PROTO_ARGS((DLL list));
extern DLL_INFO _dll_delete_last PROTO_ARGS((DLL list));
extern DLL_INFO _dll_delete_info PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_INFO _dll_inspect PROTO_ARGS((DLL_ITEM curr));
extern DLL_INFO _dll_inspect_first PROTO_ARGS((DLL list));
extern DLL_INFO _dll_inspect_last PROTO_ARGS((DLL list));
extern DLL_ITEM _dll_search PROTO_ARGS((DLL list, DLL_INFO info));
extern int _dll_compare PROTO_ARGS((DLL x, DLL y));
extern DLL _dll_union PROTO_ARGS((DLL x, DLL y));
extern DLL _dll_intersection PROTO_ARGS((DLL x, DLL y));
extern DLL _dll_difference PROTO_ARGS((DLL x, DLL y));
extern void _dll_apply PROTO_ARGS((DLL list, void (*f)()));
extern int _dll_index PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_ITEM _dll_s_add PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_ITEM _dll_u_add PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_ITEM _dll_su_add PROTO_ARGS((DLL list, DLL_INFO info));
extern DLL_INFO _dll_s_delete PROTO_ARGS((DLL list, DLL_INFO info));
extern void _dll_exit PROTO_ARGS((int error));
