/*
 * symbol table manager
 */

#include "tiltype.h"
#include "dll.h"

/* constants for class identification */

#define ADM     0
#define SOR     1
#define FUN     2
#define ATM     3
#define PRO     4
#define SET     5
#define COM     6
#define VAR     7
#define EQU     8
#define DEF     9
#define PRM     10
#define REN     11
#define BIN     12
#define IMP     13
#define MOD     14
#define UND     15


struct sor_info {
    char *name;
};


/* check if function is constructor. input function index */
#define is_constructor(x) fun[x].eq_cnt == 0

struct fun_info {
    char *name;
    int operator;		/* indicates FUNCTION/PREFIX/INFIX operator */
    int arity;			/* arity of function */
    int *i_type;		/* array of indexes into sort table */
    int o_type;			/* index into sort table */
    int eq_cnt;			/* number of equations for this function */
    int *eq;			/* array of indexes to equations */
};

struct var_info {
    char *name;
    int type;			/* index into sort table */
};

struct equ_info {
    char *name;
    struct obj_info *lhs;	/* lhs of equation */
    struct obj_info *rhs;	/* rhs of equation */
    int arity;			/* number of conditions */
    struct equ_info *condition;	/* list of conditions */
    int matches;		/* number of succesful matches */
};

#define NO_OP      0
#define UNARY_OP   1
#define BINARY_OP  2

#define UNTYPED -1

/* tables.c */
extern int NR_SOR;
extern int NR_FUN;
extern int NR_VAR;
extern int NR_EQU;

extern int max_arity;

extern struct sor_info *sor;
extern struct fun_info *fun;
extern struct var_info *var;
extern struct equ_info *equ;

extern void init_trs PROTO_ARGS((struct module *mod));
extern struct obj_info *read_term PROTO_ARGS((struct ae_term *t));
extern char *obj_name PROTO_ARGS((struct obj_info *ptr));
extern void dump_term PROTO_ARGS((struct obj_info *trm));
extern void write_term PROTO_ARGS((struct obj_info *trm));
extern struct obj_info *lookup_const PROTO_ARGS((char *name));
extern struct obj_info *lookup_fun PROTO_ARGS((char *name, DLL list, int mode));
extern void print_trs PROTO_ARGS((void));
