/*
 * symbol table manager
 */

#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "psf_malloc.h"
#include "dll.h"
#include "objects.h"
#include "tiltype.h"
#include "readtil.h"
#include "fieldex.h"
#include "options.h"
#include "main.h"
#include "tables.h"

/* global variables exported from this file */

int NR_SOR, NR_FUN, NR_VAR, NR_EQU;
int max_arity = 0;

struct sor_info *sor;
struct fun_info *fun;
struct var_info *var;
struct equ_info *equ;

static int operator(name)		/* BINARY INFIX, UNARY PREFIX, FUNCTION */
    char *name;
{
    char *ptr;

    if (*name == '_') {
	return (BINARY_OP);
    }
    for (ptr = name++; *ptr != '\0'; ptr++) {
    }
    if (*(ptr - 1) == '_') {
	return (UNARY_OP);
    } else {
	return (NO_OP);
    }
}


static char *op_filter(s)
    char *s;
{
    char *t;

    if (*s == '_') {		/* it is an operator */
	s++;
    }
    for (t = (s + 1); *t != '\0'; t++) {
    }
    if (*(t - 1) == '_') {
	*(t - 1) = '\0';
    }
    return (s);
}


static char *get_name(s,table,key)
    char *s;
    tabletype table;
    keytype key;
{
    return (psf_strdup(field_extract("n", s,table,key)));
}


void init_trs(mod)
    struct module *mod;
{
    int i, j;
    int index;

    NR_SOR = mod->entries_table[SOR];
    NR_FUN = mod->entries_table[FUN];
    NR_VAR = mod->entries_table[VAR];
    NR_EQU = mod->entries_table[EQU];

    sor = PSF_NMALLOC(struct sor_info, NR_SOR);
    fun = PSF_NMALLOC(struct fun_info, NR_FUN);
    var = PSF_NMALLOC(struct var_info, NR_VAR);
    equ = PSF_NMALLOC(struct equ_info, NR_EQU);

    for (i = 0; i < NR_SOR; i++) {
	sor[i].name = get_name(mod->sor[i + 1].ff,SOR,i+1);
    }


    for (i = 0; i < NR_FUN; i++) {
	fun[i].name = op_filter(get_name(mod->fun[i + 1].ff));
	fun[i].operator = operator(get_name(mod->fun[i + 1].ff,FUN,i+1));
	fun[i].arity = mod->fun[i + 1].sor_indlist.a;
	if (max_arity < fun[i].arity) {
	    max_arity = fun[i].arity;
	}
	fun[i].i_type = PSF_NMALLOC(int, fun[i].arity);
	for (j = 0; j < fun[i].arity; j++) {
	    fun[i].i_type[j] = mod->fun[i + 1].sor_indlist.indlist[j].key - 1;
	}
	fun[i].o_type = mod->fun[i + 1].return_list.indlist[0].key - 1;
	fun[i].eq_cnt = 0;
    }


    for (i = 0; i < NR_VAR; i++) {
	var[i].name = get_name(mod->var[i + 1].ff,VAR,i+1);
	if (mod->var[i + 1].ind.table == SOR) {
	    var[i].type = mod->var[i + 1].ind.key - 1;
	} else {
	    var[i].type = mod->set[mod->var[i + 1].ind.key].ind.key - 1;
	}
    }


    if (Option_Reverse) {
	index = NR_EQU + 1;
    } else {
	index = 0;
    }

    for (i = 0; i < NR_EQU; i++) {

	if (Option_Reverse) {
	    index--;
	} else {
	    index++;
	}

	equ[i].name = get_name(mod->equ[index].ff,EQU,index);
	equ[i].lhs = read_term(&mod->equ[index].aet1);
	equ[i].rhs = read_term(&mod->equ[index].aet2);
	equ[i].arity = mod->equ[index].a;
	equ[i].condition = PSF_NMALLOC(struct equ_info, equ[i].arity);
	equ[i].matches = 0;
	for (j = 0; j < equ[i].arity; j++) {
	    equ[i].condition[j].lhs = read_term(&mod->equ[index].guard[j].aet1);
	    equ[i].condition[j].rhs = read_term(&mod->equ[index].guard[j].aet2);
	}

	fun[equ[i].lhs->index].eq_cnt++;	/* one more equation for this
						 * fn */
    }



    for (i = 0; i < NR_FUN; i++) {	/* reserve memory for eq-lists */
	fun[i].eq = PSF_NMALLOC(int, fun[i].eq_cnt);
	fun[i].eq_cnt = 0;
    }

    for (i = 0; i < NR_EQU; i++) {
	fun[equ[i].lhs->index].eq[fun[equ[i].lhs->index].eq_cnt++] = i;
    }
}



struct obj_info *read_term(t)
    struct ae_term *t;
{
    struct obj_info *tmp;
    int i;

    alloc_obj(tmp);
    tmp->status.type = (t->ind.table == FUN) ? FUN_TYPE : VAR_TYPE;
    tmp->index = t->ind.key - 1;
    tmp->ref = 1;
    tmp->status.processed = FALSE;
    tmp->arg = NULL;

    if (is_function(tmp)) {
	if (fun[tmp->index].arity != 0) {
	    tmp->arg = PSF_NMALLOC(struct obj_info *, fun[tmp->index].arity);
	    for (i = 0; i < fun[tmp->index].arity; i++) {
		tmp->arg[i] = read_term(&t->ae_list[i]);
	    }
	}
    }
    return (tmp);
}



char *obj_name(ptr)
    struct obj_info *ptr;
{
    return (fun[ptr->index].name);
}


void dump_term(trm)
    struct obj_info *trm;
{
    int i;
    struct obj_info *ptr;

    printf("\n---------------[%s@%ld]------------------\n", obj_name(trm),
      (unsigned long)trm);
    printf("class : %d\n", is_function(trm));
    printf("index : %d\n", trm->index);
    printf("refs  : %d\n", trm->ref);
    printf("arity : %d\n", fun[trm->index].arity);
    for (i = 0; i < fun[trm->index].arity; i++) {
	printf("arg %d : %s@%ld\n", i + 1, obj_name(trm->arg[i]),
          (unsigned long)trm->arg[i]);
    }
    printf("---------------------------------------\n");

    for (i = 0; i < fun[ptr->index].arity; i++) {
	dump_term(trm->arg[i]);
    }
}


#define WRITE_DEBUG 0

void write_term(trm)
    struct obj_info *trm;
{
    int i;

    if (is_function(trm)) {
	switch (fun[trm->index].operator) {

	case NO_OP:
	    printf("%s", fun[trm->index].name);

#define EXT_INFO 0

#if EXT_INFO
	    printf("<%d%d%d>",
		   trm->status.processed, trm->status.closed, trm->status.nf);

	    printf("[%d]@%x",
		   trm->ref, trm);
#endif

	    for (i = 0; i < fun[trm->index].arity; i++) {
		if (i == 0) {
		    printf("(");
		} else {
		    printf(",");
		}
		write_term(trm->arg[i]);
		if (i == fun[trm->index].arity - 1) {
		    printf(")");
		}
	    }
	    break;

	case UNARY_OP:
	    printf("(%s ", fun[trm->index].name);

#if EXT_INFO
	    printf("<%d%d%d>",
		   trm->status.processed, trm->status.closed, trm->status.nf);

	    printf("[%d]@%x ",
		   trm->ref, trm);
#endif

	    write_term(trm->arg[0]);
	    printf(")");
	    break;

	case BINARY_OP:
	    printf("(");
	    write_term(trm->arg[0]);
	    printf(" %s ", fun[trm->index].name);

#if EXT_INFO
	    printf("<%d%d%d>",
		   trm->status.processed, trm->status.closed, trm->status.nf);

	    printf("[%d]@%x ",
		   trm->ref, trm);
#endif

	    write_term(trm->arg[1]);
	    printf(")");
	    break;

	default:
	    printf("unknown operator: %d", fun[trm->index].operator);
	    break;

	}
    } else {
	printf("%s", var[trm->index].name);

#if EXT_INFO
	printf("<%d%d%d>",
	       trm->status.processed, trm->status.closed, trm->status.nf);

	printf("[%d]@%x",
	       trm->ref, trm);
#endif

    }
}



#define DEBUG_LOOKUP 0

struct obj_info *lookup_const(name)
    char *name;
{
    int i;
    struct obj_info *obj;


#if DEBUG_LOOKUP
    printf("lookup_const: %s\n", name);
#endif


    alloc_obj(obj);
    obj->status.type = FUN_TYPE;
    obj->arg = NULL;
    obj->status.processed = FALSE;
    obj->ref = 1;

    for (i = 0; i < NR_FUN; i++) {
	if (fun[i].arity == 0) {
	    if (strcmp(fun[i].name, name) == 0) {
		obj->index = i;
		return (obj);
	    }
	}
    }
    obj->index = UNTYPED;

    error_line();
    fprintf(stderr, "%s: unknown constant function \"%s\"\n", progname, name);

    return (obj);
}


struct obj_info *lookup_fun(name, list, mode)
    char *name;
    DLL list;
    int mode;
{
    int i, j, the_arity;
    struct obj_info *obj, *the_info;
    DLL_ITEM ptr;


#if DEBUG_LOOKUP
    printf("lookup_fun: %s\n", name);
#endif


    alloc_obj(obj);
    the_arity = dll_count(list);
    obj->status.type = FUN_TYPE;
    obj->status.processed = FALSE;
    obj->ref = 1;
    obj->arg = NULL;

    DLL_FORALL(list, ptr) {
	the_info = (struct obj_info *) dll_inspect(ptr);

#if DEBUG_LOOKUP
	printf("[%d]", the_info->index);
#endif

	if (the_info->index == UNTYPED) {	/* untyped sub-term */
	    obj->index = UNTYPED;
	    return (obj);
	}
    }

#if DEBUG_LOOKUP
    printf("\n");
#endif

    for (i = 0; i < NR_FUN; i++) {
	if (fun[i].arity == the_arity) {
	    if (strcmp(fun[i].name, name) == 0) {

		obj->arg = PSF_NMALLOC(struct obj_info *, the_arity);

		for (j = 0, ptr = dll_go_first(list);
			j < the_arity;
			j++, ptr = dll_go_fw(ptr)) {
		    the_info = (struct obj_info *) dll_inspect(ptr);
		    if (fun[i].i_type[j] != fun[the_info->index].o_type) {
			break;
		    }
		    obj->arg[j] = the_info;
		    if (j == (the_arity - 1)) {	/* last argument is also OK? */
			obj->index = i;
			return (obj);
		    }
		}
	    }
	}
    }

    obj->index = UNTYPED;

    error_line();
    switch (mode) {
    case NO_OP:
	fprintf(stderr, "%s: unknown function \"%s : ", progname, name);
	break;

    case UNARY_OP:
	fprintf(stderr, "%s: unknown unary operator \"%s_ : ", progname, name);
	break;

    case BINARY_OP:
	fprintf(stderr, "%s: unknown binary operator \"_%s_ : ", progname, name);
	break;

    default:
	fprintf(stderr,
	  "%s: ### Program Error in lookup_fun.  Unknown operator mode: %d\n",
		progname, mode);
    }

    DLL_FORALL(list, ptr) {
	the_info = (struct obj_info *) dll_inspect(ptr);
	if (dll_first(list, ptr)) {
	    fprintf(stderr, "%s", sor[fun[the_info->index].o_type].name);
	} else {
	    fprintf(stderr, " # %s", sor[fun[the_info->index].o_type].name);
	}
    }
    fprintf(stderr, "\"\n");

    return (obj);
}


void print_trs()
{
    int i, j;

    printf("sorts\n");
    for (i = 0; i < NR_SOR; i++) {
	printf("%3d. %s\n", i, sor[i].name);
    }
    printf("\n");

    printf("functions\n");
    for (i = 0; i < NR_FUN; i++) {

	printf("%3d. ", i);
	if (fun[i].operator == BINARY_OP) {
	    printf("_");
	}
	printf("%s", fun[i].name);
	if (fun[i].operator) {
	    printf("_");
	}
	printf(" : ");

	for (j = 0; j < fun[i].arity; j++) {
	    if (j == 0) {
		printf("%s ", sor[fun[i].i_type[j]].name);
	    } else {
		printf("# %s ", sor[fun[i].i_type[j]].name);
	    }
	}
	printf("-> %s\n", sor[fun[i].o_type].name);
    }
    printf("\n");

    printf("variables\n");
    for (i = 0; i < NR_VAR; i++) {
	printf("%3d. %s : %s\n", i, var[i].name,
	       sor[var[i].type].name);
    }
    printf("\n");

    printf("equations\n");
    for (i = 0; i < NR_EQU; i++) {
	printf("%3d. ", i);
	write_term(equ[i].lhs);
	printf(" = ");
	write_term(equ[i].rhs);

	if (equ[i].arity != 0) {
	    printf(" when\n\t");
	    for (j = 0; j < equ[i].arity; j++) {
		write_term(equ[i].condition[j].lhs);
		printf(" = ");
		write_term(equ[i].condition[j].rhs);
		if (j != equ[i].arity - 1) {
		    printf(",\n\t");
		}
	    }
	}
	printf("\n");
    }
    printf("\n");

    /*
     * printf("functions with equations\n"); for (i=0; i<NR_FUN; i++) {
     * 
     * printf("%3d. ",i); if (fun[i].operator == BINARY_OP) { printf("_"); }
     * printf("%s",fun[i].name); if (fun[i].operator) { printf("_"); } printf("
     * : ");
     * 
     * for (j=0; j<fun[i].arity; j++) { if (j == 0) { printf("%s
     * ",sor[fun[i].i_type[j]].name); } else { printf("# %s
     * ",sor[fun[i].i_type[j]].name); } } printf("->
     * %s\n",sor[fun[i].o_type].name); for (j=0; j<fun[i].eq_cnt; j++) {
     * printf("   [%2d] ",fun[i].eq[j]); write_term(equ[fun[i].eq[j]].lhs);
     * printf(" = "); write_term(equ[fun[i].eq[j]].rhs); if (equ[j].arity != 0)
     * { printf(" when\n\t  "); for (k=0; k<equ[j].arity; k++) {
     * write_term(equ[j].condition[k].lhs); printf(" = ");
     * write_term(equ[j].condition[k].rhs); if (k != equ[j].arity-1) {
     * printf(",\n\t  "); } } } printf("\n"); } printf("\n"); }
     */
    printf("\n");

}
