/*
 * object manipulation utilities
 */


#define FUN_TYPE        0
#define VAR_TYPE        1

#define is_function(x) !(x->status.type)
#define is_variable(x) x->status.type
#define is_processed(x) x->status.processed
#define is_closed(x) x->status.closed
#define is_nf(x) x->status.nf
#define is_failure(x) x->status.failure
#define is_packed(x) x->status.packed


struct status_bits {		/* status bits */
    unsigned type:1;		/* function or variable */
    unsigned processed:1;	/* status bits set */
    unsigned closed:1;		/* term is closed */
    unsigned nf:1;		/* term is in normal form */
    unsigned failure:1;		/* term is packed */
    unsigned packed:1;		/* term is packed */
};


struct obj_info {
    int index;			/* index into function or variable table */
    int ref;			/* number of references to this object */
    struct obj_info **arg;	/* list of arguments */
    struct status_bits status;	/* status bits */
};


#define alloc_obj(x)	if (free_list == NULL) { 			\
			  x = PSF_MALLOC(struct obj_info);		\
			} else {					\
			  x = free_list;				\
			  free_list = (struct obj_info *)free_list->arg;\
			}

#define free_obj(x)	x->arg = (struct obj_info **)free_list;		\
			free_list = x

/* objects.c */
extern struct obj_info *free_list;
extern struct obj_info **fl_arg;
extern struct obj_info **alloc_arg PROTO_ARGS((int cnt));
extern void free_arg PROTO_ARGS((struct obj_info **arg, int cnt));
