.TH INITIAL 1L "July 13, 1992" "UvA FWI" "PSF-Toolkit"
.UC 4
.SH NAME
initial \- initial algebra report generator
.SH SYNOPSIS
.B initial 
[-c] [-d] [-f] [-g] [-o] [-r] [-v] [-s
.IR  size
]
.IR TIL-file
.SH DESCRIPTION
.B initial
tries to calculate the initial algebras of the sorts specified in its
TIL-file argument.  The output is a report showing each
sort and the number of elements in its initial algebra.
.PP
The program starts by determining the dependencies between the sorts.
A sort
.IR S
is dependent on sort
.IR T
if 
.IR T
is part of the input type of
.IR S
.
.PP
Next, for each sort a list is created, which will be used to register
the normal forms for this sort.
.PP
Elements of the initial algebra are said to be found in so-called
.IR segments .
These segments are numbered and they are constructed in a repetitive manner.
The elements in segment
.IR n
depend on elements in segment
.IR n-1.
All constant functions, as they appear in the TIL-file, are normal forms
and they are added to the appropriate lists.  They are said to form segment
.IR 0
.
.PP
In the next phase the program constructs segment
.IR 1
by inspecting all non-constant functions.
For each combination
of available arguments, which are the normal forms on the list attached to
each sort,
a term is constructed and rewritten.  If the resulting term is not already part
of the list of normal forms for this sort, it is added.  This phase is
repeated, each time generating a segment on a higher level, until no new
combinations of arguments can be found.  This is detected by means of the
notion of
.IR activity
of a sort.
.PP
A sort is said to be active in segment
.IR n+1
, if a sort on which it depends has been extended with new normal forms
in segment
.IR n.
If there are no more active sorts, the calculation has finished.
.PP
.SH OPTIONS
.TP 4n
.B -c
can be used to show the contents, the normal forms,
of each initial algebra.
.TP
.B -d
shows the dependencies between the different sorts.
.TP
.B -o
uses only constructor functions to generate new terms.
Constructor functions in this case are defined as functions that have no
accompanying rewrite rules.
.br
.B Caution:
Usage of this option may result in incomplete initial algebras.
.TP
.B -v
starts the verbose mode.  The version number is shown, as well as the numbers
of the segments as soon as they are entered.
.TP
.B -g
shows a new element of the initial algebra as soon as it is generated.
.TP
.B -f
shows the name of the function currently examined for rewriting as well as
the number of combinations of its arguments.  If the program seems to be
doing nothing for a while, this option can be used to see how many combinations
it is trying.
.TP
.B -r
shows all the rewrites that are performed in order to find new normal forms.
.TP
.B -s
.IR size
gives the maximum number of elements of the initial algebra for any sort.
The default size is 100.  If this limit is exceeded for a certain sort,
the program does not try to find more elements of its initial algebra. 
.SH SEE ALSO
trs_check (1L)
.SH EXIT STATUS
.IR initial
returns the following exit codes:
.br
	0	no errors
.br
	1	wrong calling sequence
.br
	2	input file could not be opened
.br
	3	input file contains semantical errors (trs_check)
.br
	4	maximum number of elements reached
.SH AUTHOR
Gert Veltink, University of Amsterdam (veltink@fwi.uva.nl)
