/*
 * variable binding routines
 */

#ifndef _BINDINGS_H_
#define _BINDINGS_H_

struct bind_info {
    int cnt;			/* number of bound variables */
    int ref_cnt;		/* number of vars referring to each other */
    struct obj_info **value;	/* pointer to value of variable */
    int *bound_to;		/* list of indexes of bound variables */
    int *ref;			/* list of references to values of variables */
};


/* defines */

#define NO_REF -1

#define bound(x,b) (b->value[x] != NULL)
#define clear_bindings(b) if(b->cnt>0){do_clears(b);}
#define bind_variable(i,t,b) b->value[i]=t;b->bound_to[b->cnt++]=i;

/* bindings.c */
extern struct bind_info *alloc_bindings PROTO_ARGS((void));
extern void free_bindings PROTO_ARGS((struct bind_info *b));
extern void print_bindings PROTO_ARGS((struct bind_info *b));
extern void erase_bindings PROTO_ARGS((struct bind_info *b));
extern void do_clears PROTO_ARGS((struct bind_info *b));
extern void copy_bindings PROTO_ARGS((struct bind_info *dest, struct bind_info *src));
#endif /* _BINDINGS_H_ */
