/*
 * variable binding routines
 */

#include <stdio.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "psf_standards.h"

#include "tables.h"
#include "objects.h"
#include "rewrite.h"
#include "bindings.h"

/* function declarations */

#define bound(x,b) (b->value[x] != NULL)
#define clear_bindings(b) if(b->cnt>0){do_clears(b);}
#define bind_variable(i,t,b) b->value[i]=t;b->bound_to[b->cnt++]=i;


struct fl_element {
    struct fl_element *link;	/* link to next element */
};

static struct fl_element *bind_fl = NULL;


struct bind_info *alloc_bindings()
{
    struct bind_info *ptr;

    if (bind_fl == NULL) {	/* create a new binding structure */

	ptr = PSF_MALLOC(struct bind_info);
	ptr->value = PSF_NMALLOC(struct obj_info *, NR_VAR);
	ptr->bound_to = PSF_NMALLOC(int, NR_VAR);
	ptr->ref = PSF_NMALLOC(int, NR_VAR);

    } else {
	ptr = (struct bind_info *) bind_fl;
	bind_fl = (bind_fl->link);
    }
    erase_bindings(ptr);
    return (ptr);
}


void free_bindings(b)
    struct bind_info *b;
{
    struct fl_element *tmp;

    tmp = (struct fl_element *) b;
    tmp->link = bind_fl;
    bind_fl = tmp;
}


void print_bindings(b)
    struct bind_info *b;
{
    int i;

    for (i = 0; i < NR_VAR; i++) {
	if (bound(i, b)) {
	    level_print();
	    printf(" [%s/", var[i].name);
	    write_term(b->value[i]);
	    printf("]\n");
	}
    }
}


void erase_bindings(b)
    struct bind_info *b;
{
    int i;

    b->cnt = b->ref_cnt = 0;
    for (i = 0; i < NR_VAR; i++) {
	b->value[i] = NULL;
	b->bound_to[i] = b->ref[i] = NO_REF;
    }
}


void do_clears(b)
    struct bind_info *b;
{
    int i;
    int index;

    for (i = 0; i < b->cnt; i++) {
	index = b->bound_to[i];
	b->value[index] = NULL;
	b->bound_to[i] = b->ref[index] = NO_REF;
    }
    b->cnt = b->ref_cnt = 0;
}


#if 0
struct bind_info *create_bindings()
{
    struct bind_info *tmp;

    tmp = PSF_MALLOC(struct bind_info);
    tmp->value = PSF_NMALLOC(struct obj_info *, NR_VAR);
    tmp->bound_to = PSF_NMALLOC(int, NR_VAR);
    tmp->ref = PSF_NMALLOC(int, NR_VAR);
    return (tmp);
}

#endif


void copy_bindings(dest, src)
    struct bind_info *dest, *src;
{
    int index;
    int i;

    clear_bindings(dest);
    dest->cnt = src->cnt;
    dest->ref_cnt = src->ref_cnt;
    for (i = 0; i < src->cnt; i++) {
	index = src->bound_to[i];
	dest->value[index] = src->value[index];
	dest->bound_to[i] = src->bound_to[i];
	dest->ref[index] = src->ref[index];
    }
}
