/*
        dll.h : include file for doubly linked list structures
*/

#ifndef _DLL_H_
#define _DLL_H_

typedef void *DLL_INFO;

typedef struct dll_it {
        struct dll_it   *bw, *fw;
        DLL_INFO                info;
} DLL_ITBL, *DLL_ITEM;

typedef struct dll_def {
        DLL_ITEM first, last;
} DLL_BLOCK, *DLL;


/* useful macros */

/* DLL_FORALL: make a for loop traversing all elements from l using p as ptr */
#define DLL_FORALL(l,p) for(p=dll_go_first(l);p!=NULL;p=dll_go_fw(p))

/* dll.c */
extern DLL dll_create PROTO_ARGS((void));
extern void dll_flush PROTO_ARGS((DLL ptr));
extern void dll_dispose PROTO_ARGS((DLL ptr));
extern DLL dll_copy PROTO_ARGS((DLL list));
extern DLL_ITEM create_item PROTO_ARGS((DLL_INFO info));
extern void dispose_item PROTO_ARGS((DLL_ITEM ptr));
extern int dll_empty PROTO_ARGS((DLL list));
extern int dll_first PROTO_ARGS((DLL list, DLL_ITEM curr));
extern int dll_last PROTO_ARGS((DLL list, DLL_ITEM curr));
extern DLL_INFO dll_inspect PROTO_ARGS((DLL_ITEM curr));
extern DLL_ITEM dll_go_first PROTO_ARGS((DLL list));
extern DLL_ITEM dll_go_last PROTO_ARGS((DLL list));
extern DLL_ITEM dll_go_fw PROTO_ARGS((DLL_ITEM curr));
extern DLL_ITEM dll_go_bw PROTO_ARGS((DLL_ITEM curr));
extern void dll_insert PROTO_ARGS((DLL list, DLL_INFO info));
extern void dll_insert_at PROTO_ARGS((DLL list, DLL_ITEM curr, DLL_INFO info));
extern void dll_append PROTO_ARGS((DLL list, DLL_INFO info));
extern void dll_append_at PROTO_ARGS((DLL list, DLL_ITEM curr, DLL_INFO info));
extern DLL_INFO del_item PROTO_ARGS((DLL list, DLL_ITEM ptr));
extern DLL_INFO dll_del_front PROTO_ARGS((DLL list));
extern DLL_INFO dll_del_rear PROTO_ARGS((DLL list));
extern DLL_INFO dll_del_at PROTO_ARGS((DLL list, DLL_ITEM curr));
extern void dll_apply PROTO_ARGS((DLL list, void (*f)()));
extern void dll_insert_sorted PROTO_ARGS((DLL list, DLL_INFO info, int (*cmp)()));
extern void dll_insert_sorted_unique PROTO_ARGS((DLL list, DLL_INFO info, int (*cmp)()));
extern DLL_INFO dll_delete_sorted PROTO_ARGS((DLL list, DLL_INFO info, int (*cmp)()));
extern DLL_ITEM dll_contains PROTO_ARGS((DLL list, DLL_INFO info, int (*cmp)()));
extern int dll_compare PROTO_ARGS((DLL x, DLL y, int (*f)()));
extern int dll_count PROTO_ARGS((DLL list));

#endif /* _DLL_H_ */
