.TH TRS 1L "November 9, 1995" "UvA FWI" "PSF-Toolkit"
.UC 4
.SH NAME
trs \- a term rewrite system for TIL expressions
.SH SYNOPSIS
.B trs
[\|-r\|]
.I file
.SH DESCRIPTION
.B trs
rewrites terms given by the user, either interactively or through standard
input.
Rewriting is done according to the TIL-code, which is read from
.IR file .
The result of rewritings is written on standard output.
.PP
Terms given by the user, must be in the form as in a PSF specification.
.B trs
uses inside out type checking for deciding which item is to be used.
When there are items with the same name and types for their arguments,
they have to be disambiguated by
specifying the module it originates from, as in:
.RS
X.item
.RE
which specifies
.I item
from module
.IR X .
.PP
In rewriting the terms,
.B trs
uses the rightmost-innermost strategy.
.PP
.B trs
ends when an end of file is detected or when given an empty line.
.PP
When an error has been found in parsing a term, a message about the error
is generated on standard error, followed by the term, with
.I ???
inserted after the place the error was found.
Due to infix operators, the
.I ???
may be placed a little further ahead in the term then where the error
was found.
.SS Debugging
There is a possibility for tracing in
.BR trs .
The command
.RS
> trace on
.RE
sets tracing on.  Tracing can be put off, by changing
.I on
to
.I off
in the above command.
The space between > and
.I trace
is optional.
.PP
Also some statistics on rewriting can be obtained with the command
.RS
> stat
.RE
This gives the numbers of matches and the number of tries for each
rewrite- rule done so far.
These numbers can be reset withe the command
.RS
> stat reset
.RE
.SH OPTIONS
.TP
.B \-h
Prints a help message.
.TP
.B \-r
Term rewriting is done with the equations in reverse order.
.TP
.B \-v
Displays the version number of
.BR trs .
.SH SEE ALSO
.BR psf (1L)
.SH AUTHOR
Bob Diertens, University of Amsterdam (bobd@fwi.uva.nl)
.br
Casper H.S. Dik, University of Amsterdam (casper@fwi.uva.nl)
