#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "psf_prototype.h"
#include "psf_fopen.h"
#include "psf_standards.h"
#include "env_variables.h"
#include "psf_exits.h"

#include "tiltype.h"
#include "readtil.h"
#include "eqm.h"

#include "prtilparts.h"
#include "parsetermutil.h"
#include "parsetermerror.h"
#include "parseterm.h"
#include "scanterm.h"
#include "main.h"
#include "version.h"

extern int optind;

char *progname;
char *filename;

static struct module mod;

static void usage()
{
    (void) fprintf(stderr, "usage: %s [-hrv] til-file\n", progname);
}

static void version()
{
    (void) fprintf(stderr, "trs version %s, last compiled %s\n",
		   VERSION, __DATE__);
}

int main(argc, argv)
    int argc;
    char *argv[];
{
    FILE *input;
    eqm_t *eqm;
    int i;
    struct ae_term *aet;
    int opt;
    psf_file pf;
    int interactive;
    static suffix suffixes[] = {{TILSUFFIX, TILSUFFIX_DEFAULT}, {NULL, NULL}};
    int opts;

    if (argc == 0) {
	(void) fprintf(stderr, "who am I ?\n");
	exit(EXIT_HELP);
    }
    progname = psf_basename(argv[0]);

    opts = EQM_PRINT_STATS;
    while ((opt = getopt(argc, argv, "vhr")) != EOF) {
	switch (opt) {
	case 'r':
	    opts |= EQM_REVERSE;
	    break;
	case 'v':
	    version();
	    break;
	case 'h':
	    usage();
	    exit(0);
	    break;
	case '?':
	    usage();
	    exit(EXIT_CMD_LINE_ERR);
	}
    }
    eqm_setoptions(opts);

    if (optind != argc - 1) {
	usage();
	exit(EXIT_CMD_LINE_ERR);
    }
    pf = psf_fopen(argv[optind],suffixes);
    filename = pf.name;
    input = pf.fp;

    if (read_module(&mod, input)) {
	fprintf(stderr, "%s: error in input\n", progname);
	exit(EXIT_SYNTAX_ERR);
    }
    eqm = create_eqm(mod.entries_table[FUN]);
    for (i = 1; i <= mod.entries_table[EQU]; i++)
	eqm = add_equation(eqm, mod.equ[i]);

    set_print_current_module(&mod);
    set_print_output_file(stdout);

    init_parse_util(&mod);

    interactive = isatty(fileno(stdin));
    while (1) {
	if (interactive) {
	    printf("--> ");
	    fflush(stdout);
	}
	if (yyparse())
	    continue;
	if (Parseterm_Aet == NULL) {
	    if (Parseterm_status > 0) {
		fprintf(stderr, "%s", get_parseterm_error());
		print_scan_error_str();
		continue;
	    } else if (Parseterm_status == 0)
		exit(0);
	    continue;
	}
	print_ae_term(Parseterm_Aet);
	printf("\t= ");
	aet = term_reduce(eqm, Parseterm_Aet);
	print_ae_term(aet);
	printf("\n");
    }
}
