#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_fopen.h"
#include "psf_malloc.h"
#include "psf_standards.h"
#include "main.h"
#include "tiltype.h"
#include "readtil.h"
#include "writetil.h"
#include "env_variables.h"
#include "version.h"

void usage()
{
    (void) fprintf(stderr, "usage: %s -[vh] [tilfile]\n", progname);
}

void version()
{
    (void) fprintf(stderr, "til_til version %s, last compiled %s\n", VERSION,
				__DATE__);
}

extern int optind;
char *progname;
char *filename;

static char *base_of_name(s)
    char *s;
{
    char *p, *q, *r;
    int n;

    p = strrchr(s, '/');
    if (p)
	p++;
    else
	p = s;

    q = strrchr(p, '.');
    if (!q)
	return psf_strdup(p);
    else {
	n = q-p;
	r = PSF_NMALLOC(char, n+1);
	r = strncpy(r, p, n);
	r[n] = '\0';
	return r;
    }
}


static void til_to_til(s, fp)
    char *s;
    FILE *fp;
{
    struct module mod;

    mod.name = base_of_name(s);
    if (read_module(&mod, fp)) {
	(void) fprintf(stderr, "Error in input\n");
	exit(1);
    }
    write_module(&mod, stdout);
}


int main(argc, argv)
    int argc;
    char *argv[];
{
    static suffix suffixes[] = {{TILSUFFIX, TILSUFFIX_DEFAULT}, {NULL, NULL}};
    FILE *input;
    int opt;
    psf_file pf;

    if (argc == 0) {
	(void) fprintf(stderr, "who am I?\n");
	exit(1);
    }
    progname = psf_basename(argv[0]);
    while ((opt = getopt(argc, argv, "hv")) != -1) {
	switch (opt) {
	case 'v':
	    version();
	    break;
	case 'h':
	    usage();
	    exit(0);
	case '?':
	    usage();
	    exit(1);
	}
    }

    write_til_init();

    switch (argc - optind) {
    case 0:
	filename = "stdin";
	til_to_til("stdin", stdin);
	break;
    case 1:
	pf = psf_fopen(argv[optind], suffixes);
	input = pf.fp;
	filename = pf.name;
	til_to_til(argv[optind], input);
	break;
    default:
	usage();
	exit(1);
    }

    return 0;
}
