#include <stdio.h>
#include <string.h>
#include <setjmp.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "main.h"
#include "tiltype.h"
#include "readtil.h"
#include "readtiltype.h"
#include "fieldex.h"
#include "prtilparts.h"
#include "iwtabletype.h"
#include "tablematch.h"
#include "priw.h"

struct module mod;

struct module *get_til_module()
{
    return (&mod);
}

static char *base_of_name(s)
    char *s;
{
    char *p, *q, *r, *end;
    int n;

    p = end = s + strlen(s);
    while (*p != '/' && p > s)
	p--;
    if (*p == '/')
	p++;
    q = end;
    while (*q != '.' && q > p)
	q--;
    if (q == p)
	return p;
    else {
	n = q - p;
	r = PSF_NMALLOC(char, n + 1);
	r = strncpy(r, p, n);
	r[n] = '\0';
	return r;
    }
}

static int read_til_spec(input_name)
    char *input_name;
{
    FILE *fp;

    if ((fp = fopen(input_name, "r")) == NULL) {
	return (1);
    }
    mod.name = base_of_name(input_name);
    if (read_module(&mod, fp)) {
	fclose(fp);
	return (2);
    }
    fclose(fp);
    return (0);
}

static void read_til(fn)
    char *fn;
{
    switch (read_til_spec(fn)) {
    case 0:
	break;
    case 1:
	fprintf(stderr, "%s: can't read ", progname);
	perror(fn);
	exit(1);
    case 2:
	fprintf(stderr, "error in input-file\n");
	exit(1);
    }
}

jmp_buf til_jenv;

static char buf[10240];		/* pray this is long enough */

void view_trace(fin, fout)
FILE *fin;
FILE *fout;
{
    int c;
    unsigned int choice;
    int hide;
    unsigned int skipnr;
    struct process_expr expr;
    struct ae_term aet;
    int nr;
    int i;
    int key;
    extern struct striwtable *iwtable;
    struct strtablematch *tm;

    set_input_file(fin);	/* for readtil */
    set_print_output_file(fout);	/* for prtilparts */

    if (opt_iw) {
	fprintf(fout, "INTERWORKING %s\n", filename);
	fprintf(fout, "PROCESSES\n    ");
	print_iwprocesses(fout, iwtable);
	fprintf(fout, "\nENDPROCESSES\n");
    }

    while ((c = getc(fin)) != EOF) {
	if (c == '>') {
	    fscanf(fin, "%[^ \t\n]s ", buf);
	    if (!strcmp(buf, "file")) {
		fscanf(fin, " %[^\n]s", buf);
		if (!opt_iw && !opt_atoms) {
		    fprintf(fout, "file: %s\n", buf);
		    fflush(fout);
		}
		filename = buf;	/* for readtil */
		read_til(buf);
		set_print_current_module(&mod); /* for prtilparts */
		set_input_file(fin); /* for readtil */
	    } else if (opt_atoms) {
		/* read rest of line */
		while ((c = getc(fin)) != EOF) {
		    if (c == '\n')
			break;
		}
	    } else if (!strcmp(buf, "reset")) {
		if (!opt_iw) {
		    fprintf(fout, "reset\n");
		    fflush(fout);
		}
	    } else if (!strcmp(buf, "start")) {
		scanf(" %u ", &choice);
		if (setjmp(til_jenv)) {
		    fprintf(stderr, "error in start process\n");
		    exit(1);
		}
		read_process_expr(&expr);
		scanf(" %d ", & nr);
		if (!opt_iw) {
		    fprintf(fout, "start: %u  ", choice);
		    print_process_expr(&expr);
		}
		if (nr) {
		    if (!opt_iw) {
			fprintf(fout, " %d", nr);
		    }
		    for (i = 0; i < nr; i ++) {
			scanf(" %d ", &key);
			if (setjmp(til_jenv)) {
			    fprintf(stderr, "error in process argument\n");
			    exit(1);
			}
			read_ae_term(&aet);
			if (!opt_iw) {
			    fprintf(fout, " %s->[",
				field_extract("n", mod.var[key].ff, VAR, key));
			    print_ae_term(&aet);
			    fprintf(fout, "]");
			}
		    }
		}
		if (!opt_iw) {
		    fprintf(fout, "\n");
		    fflush(fout);
		}
	    } else if (!strcmp(buf, "sum")) {
		scanf(" %u ", &choice);
		if (setjmp(til_jenv)) {
		    fprintf(stderr, "error in sum-expr\n");
		    exit(1);
		}
		read_ae_term(&aet);
		if (!opt_iw) {
		    fprintf(fout, "sum  choice: %u  ", choice);
		    print_ae_term(&aet);
		    fprintf(fout, "\n");
		    fflush(fout);
		}
	    } else if (!strcmp(buf, "undo")) {
		if (!opt_iw) {
		    fprintf(fout, "undo\n");
		    fflush(fout);
		}
	    } else if (!strcmp(buf, "redo")) {
		if (!opt_iw) {
		    fprintf(fout, "redo\n");
		    fflush(fout);
		}
	    } else if (!strcmp(buf, "mark")) {
		fscanf(fin, " %[^\n]s", buf);
		if (!opt_iw) {
		    fprintf(fout, "mark %s\n", buf);
		    fflush(fout);
		}
	    } else if (!strcmp(buf, "goto")) {
		fscanf(fin, " %u %[^\n]s", &choice, buf);
		if (!opt_iw) {
		    fprintf(fout, "goto %u %s\n", choice, buf);
		    fflush(fout);
		}
	    } else if (!strcmp(buf, "save")) {
		if (!opt_iw) {
		    fprintf(fout, "save\n");
		    fflush(fout);
		}
	    } else {
		fprintf(stderr, "unknown info\n");
		exit(1);
	    }
	} else {
	    ungetc(c, fin);
	    fscanf(fin, "%u %d ", &choice, &hide);
	    if (opt_atoms) {
		if (hide)
		    fprintf(stdout, "skip ");
	    } else {
		if (!opt_iw) {
		    fprintf(fout, "choice: %u  hide: %d  ", choice, hide);
		}
	    }
	    if (setjmp(til_jenv)) {
		fprintf(stderr, "error in process expr\n");
		exit(1);
	    }
	    read_process_expr(&expr); /* SKP or AET */
	    if (expr.fun == SKP) {
		if (!fscanf(fin, "<%u> ", &skipnr))
		    skipnr = 0;    /* for old traces */
	    }
	    if (!opt_iw) {
		print_process_expr(&expr);
		/* parts of expr should be freed now */
		if (expr.fun == SKP)
		    fprintf(fout, "<%u>", skipnr);
		fprintf(fout, "\n");
		fflush(fout);
	    } else {
		if (expr.fun != SKP) {
		    if ((tm = match_iwtable(&expr.proc_expr.pe2, iwtable))
			== NULL) {
			fprintf(stderr, "term '");
			set_print_output_file(stderr);	/* for prtilparts */
			print_ae_term(&expr.proc_expr.pe2);
			fprintf(stderr, "' does not appear in table\n");
			exit(1);
		    } else {
			fprintf(fout, "    ");
			print_iwexpr(fout, tm, iwtable->instances);
			fprintf(fout, "\n");
		    }
		}
	    }
	}
	scanf(" ");
    }

    if (opt_iw)
	fprintf(fout, "ENDINTERWORKING\n");
}
