.TH TRACEVIEW 1L "Oct 30, 1997" "PSF-Toolkit" "LOCAL COMMANDS"
.UC 4
.SH NAME
traceview \- view traces from sim
.SH SYNOPSIS
.B traceview
[\|-a\|]
[\|-h\|]
[\|-i\fIiw-table\fP [\|-p\|]\|]
[\|-v\|]
.SH DESCRIPTION
.B traceview
reads a trace generated by
.BR sim (1L)
from stdin, and prints the trace on stdout in a readable form.
.PP
If the
.B -i
option is used, an interworking is generated from the trace.
Therefor, a translation table from the file
.I iw-table
is read. For example, this might look like this:
.RS
.nf
instances
    x, y, z
events
    a -> { x, a }
    b(f) -> { x, y, b(f) }
    c(_1, g(_2)) -> { y, z, d(_1, _2) }
.fi
.RE
The instances are the processes in an interworking.
The first event describes the translation of an action 'a' into
.RS
x ACTION a
.RE
meaning that process 'x' performs action 'a'.
.br
The second describes the translation of 'b(f)' into
.RS
x SENDS b(f) TO y
.RE
meaning that process 'x' sends message 'b(f)' to process 'y'.
.br
The third shows the use of placeholders. The placeholder '_1'
matches with the first argument of 'c', and '_2' matches with
the argument of 'g'.
The placholders in 'd' are replaced with the matched values, but
with '-' translated into '_', because a '-' is not allowed
in an identifier of an interworking.
.br
Placeholders may also be used for instances, as in
.RS
.nf
    c(_1, _2, g(_3)) -> { _1, _2, d(_3) }
.fi
.RE
Values for these placeholders are checked for appearance
in the instance list. If no such instance exists, an
error-message is given and the program exits.
.br
See
.BR iwtable.bnf (5L)
for a BNF description of the translation-tables.
.SH OPTIONS
.TP
.B \-a
Only output atoms. Discard the rest of the information in the trace.
Useful in combination with
.BR traceanim (1L).
.TP
.B \-h
Prints a help message.
.TP
.BI \-i iw-name
Generates an interworking from the trace according to the
table found in
.IR iw-name .
.TP
.B \-p
Prints the table found in the file
.IR iw-name ,
and no further output is generated.
Only valid with the
.B -i
option.
.TP
.B \-v
Displays the version-number of traceview.
.SH SEE ALSO
.BR psf (1L),
.BR sim (1L),
.BR trace_format (5L)
.BR iwtable.bnf (5L)
.SH AUTHOR
Bob Diertens, University of Amsterdam (bobd@fwi.uva.nl)
