#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "tiltype.h"
#include "iwtabletype.h"
#include "tablematch.h"
#include "viewtrace.h"
#include "fieldex.h"

static struct strsub *sub_list = NULL;

static void add_sub_list(ph, aet)
char *ph;
struct ae_term *aet;
{
    struct strsub *sub;

    sub = PSF_MALLOC(struct strsub);
    sub->name = ph;
    sub->aet = aet;
    sub->next = sub_list;
    sub_list = sub;
}

static void free_sub_list()
{
    struct strsub *sub;

    while (sub_list != NULL) {
	sub = sub_list;
	sub_list = sub_list->next;
	PSF_FREE(sub);
    }
}

static int match_name(ind, id)
struct indextype *ind;
char *id;
{
    struct module *mod;
    char *ffname;
    int l;

    mod = get_til_module();
    if (ind->table == ATM) {
	ffname = field_extract("n", mod->atm[ind->key].ff, ATM, ind->key);
	if (strcmp(ffname, id))
	    return(0);
	else
	    return(1);
    } else {
	ffname = field_extract("n", mod->fun[ind->key].ff, FUN, ind->key);
	if (ffname[0] == '_')
	    ffname ++;
	l = strlen(ffname);
	if (ffname[l - 1] == '_')
	    l --;
	if (l != strlen(id))
	    return(0);
	if (strncmp(ffname, id, l))
	    return(0);
	else
	    return(1);
    }
}

static int match(aet, term)
struct ae_term *aet;
struct strterm *term;
{
    int i;
    struct strtermlist *l;

    if (term->id[0] == '_') {
	add_sub_list(term->id, aet);
	return(1);
    }
    if (term->a != aet->a)
	return(0);
    if (!match_name(&aet->ind, term->id))
	return(0);
    for (i = 0, l = term->list; i < aet->a; i ++, l = l->next) {
	if (! match(&aet->ae_list[i], l->term))
	    return(0);
    }
    return(1);
}

struct strtablematch *match_iwtable(aet, iwt)
struct ae_term *aet;
struct striwtable *iwt;
{
    struct streventlist *el;
    struct strtablematch *tm;

    for (el = iwt->events; el != NULL; el = el->next) {
	if (match(aet, el->event->term)) {
	    tm = PSF_MALLOC(struct strtablematch);
	    tm->event = el->event;
	    tm->sub = sub_list;
	    return(tm);
	}
	free_sub_list();
    }
    return(NULL);
}

void free_table_match(tm)
struct strtablematch *tm;
{
    free_sub_list(tm->sub);
    PSF_FREE(tm);
}
