#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "psf_prototype.h"
#include "iwtabletype.h"
#include "tablematch.h"
#include "tiltype.h"
#include "fieldex.h"
#include "viewtrace.h"
#include "main.h"

static void print_term(fout, t)
FILE *fout;
struct strterm *t;
{
    int i;
    struct strtermlist *l;

    fprintf(fout, "%s", t->id);
    if (t->a) {
	fprintf(fout, "(");
	for (i = t->a, l = t->list; i > 0; i --, l = l->next) {
	    if (i < t->a)
		fprintf(fout, ", ");
	    print_term(fout, l->term);
	}
	fprintf(fout, ")");
    }
}
	    
static void print_expr(fout, e)
FILE *fout;
struct strexpr *e;
{
    fprintf(fout, "{ %s, ", e->p1);
    if (e->p2 != NULL)
	fprintf(fout, "%s, ", e->p2);
    print_term(fout, e->term);
    fprintf(fout, " }");
}

static void print_event(fout, e)
FILE *fout;
struct strevent *e;
{
    print_term(fout, e->term);
    fprintf(fout, " -> ");
    print_expr(fout, e->expr);
}

void print_iwprocesses(fout, iwt)
FILE *fout;
struct striwtable *iwt;
{
    struct strlist *l;

    for (l = iwt->instances; l->next != NULL; l = l->next) {
	fprintf(fout, "%s, ", l->name);
    }
    fprintf(fout, "%s", l->name);
}

void print_iwtable(fout, iwt)
FILE *fout;
struct striwtable *iwt;
{
    struct streventlist *el;

    fprintf(fout, "instances\n\t");
    print_iwprocesses(fout, iwt);
    fprintf(fout, "\n");
    fprintf(fout, "events\n");
    for (el = iwt->events; el != NULL; el = el->next) {
	fprintf(fout, "\t");
	print_event(fout, el->event);
	fprintf(fout, "\n");
    }
}

static void print_iwaet(fout, aet)
FILE *fout;
struct ae_term *aet;
{
    struct module *mod;
    freeformat ff;
    char *n;
    int l, i;

    mod = get_til_module();
    switch (aet->ind.table) {
    case FUN:
	ff = mod->fun[aet->ind.key].ff;
	break;
    case ATM:
	ff = mod->atm[aet->ind.key].ff;
	break;
    }
    n = field_extract("n", ff, aet->ind.table, aet->ind.key);
    if (n[0] == '_')
	n ++;
    l = strlen(n);
    if (n[l - 1] == '_')
	l --;
    n[l] = '\0';
    for (; *n != '\0'; n ++) {
	if (*n == '-')
	    putc('_', fout);
	else
	    putc(*n, fout);
    }
    fprintf(fout, "%s", n);
    if (aet->a) {
	fprintf(fout, "(");
	for (i = 0; i < aet->a; i ++) {
	    if (i)
		fprintf(fout, ", ");
	    print_iwaet(fout, &aet->ae_list[i]);
	}
	fprintf(fout, ")");
    }
}

static void print_iwterm(fout, t, sub)
FILE *fout;
struct strterm *t;
struct strsub *sub;
{
    struct strsub *s;
    int i;
    struct strtermlist *l;

    if (t->id[0] == '_') {
	for (s = sub; strcmp(t->id, s->name); s = s->next);
	print_iwaet(fout, s->aet);
	return;
    } else
	fprintf(fout, "%s", t->id);
    if (t->a) {
	fprintf(fout, "(");
	for (i = t->a, l = t->list; i > 0; i --, l = l->next) {
	    if (i < t->a)
		fprintf(fout, ", ");
	    print_iwterm(fout, l->term, sub);
	}
	fprintf(fout, ")");
    }
}
    
static void print_iwinstance(fout, in, sub, inst)
FILE *fout;
char *in;
struct strsub *sub;
struct strlist *inst;
{
    struct strsub *s;
    char *n;
    struct strlist *i;
    struct module *mod;

    if (*in == '_') {
	for (s = sub; strcmp(in, s->name); s = s->next);
	if (s->aet->a == 0) {
	    mod = get_til_module();
	    n = field_extract("n", mod->fun[s->aet->ind.key].ff,
		s->aet->ind.table, s->aet->ind.key);
	    for (i = inst; i != NULL; i = i->next) {
		if (!strcmp(i->name, n)) {
		    fprintf(fout, n);
		    return;
		}
	    }
	}
	fprintf(stderr, "%s: value '", progname);
	print_iwaet(stderr, s->aet);
	fprintf(stderr, "' for placeholder '%s' is not an instance\n", in);
	exit(1);
    } else {
	fprintf(fout, "%s", in);
    }
}

void print_iwexpr(fout, tm, inst)
FILE *fout;
struct strtablematch *tm;
struct strlist *inst;
{
    struct strexpr *e;

    e = tm->event->expr;
    if (e->p2 == NULL) {
	print_iwinstance(fout, e->p1, tm->sub, inst);
	fprintf(fout, " ACTION ");
	print_iwterm(fout, e->term, tm->sub);
    } else {
	print_iwinstance(fout, e->p1, tm->sub, inst);
	fprintf(fout, " SENDS ");
	print_iwterm(fout, e->term, tm->sub);
	fprintf(fout, " TO ");
	print_iwinstance(fout, e->p2, tm->sub, inst);
    }
}
