#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "psf_fopen.h"
#include "main.h"
#include "version.h"
#include "viewtrace.h"
#include "iwtabletype.h"
#include "priw.h"
#include "checkiw.h"
#include "y.tab.h"

char *progname;		/* name to be used in error messages */
char *filename;		/* name for input file (readtil, errordet */

void usage()
{
    (void) fprintf(stderr, "usage: %s [-h] [-i table [-p] [v]\n", progname);
}

void version()
{
    (void) fprintf(stderr, "%s version %s, last compiled %s\n", progname,
		   VERSION, __DATE__);
}

int opt_iw = 0;
char * iwtablename;
static int opt_print = 0;
int opt_atoms = 0;

int main(argc, argv)
    int argc;
    char *argv[];
{
    int c;
    extern char *optarg;
    char * iwtablename;
    psf_file psffp;
    extern FILE *yyin;
    extern struct striwtable *iwtable;

    progname = psf_basename(argv[0]);

    while ((c = getopt(argc,argv, "ahi:pv")) != EOF) {
	switch (c) {
	case 'a':
	    opt_atoms = 1;
	    break;
	case 'h':
	    usage();
	    exit(0);
	case 'i':
	    opt_iw = 1;
	    iwtablename = optarg;
	    break;
	case 'p':
	    opt_print = 1;
	    break;
	case 'v':
	    version();
	    break;
	default:
	    usage();
	    exit(EXIT_CMD_LINE_ERR);
	}
    }

    if (opt_iw) {
	psffp = psf_fopen(iwtablename, NULL);
	yyin = psffp.fp;
	filename = psffp.name;
	if (yyparse())
	    exit(1);
	fclose(psffp.fp);
	if (check_iwtable(iwtable)) {
	    exit(1);
	}
	if (opt_print) {
	    print_iwtable(stdout, iwtable);
	    exit(0);
	}
    }

    view_trace(stdin, stdout);

    return (0);
}
