%{
#include <stdio.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "iwtabletype.h"
#include "lexyacc.h"
#include "errordet.h"

struct striwtable *iwtable = NULL;

extern int line;

static struct strterm *new_term PROTO_ARGS((char *, struct strtermlist *));
static struct strtermlist *new_termlist PROTO_ARGS((struct strterm *));
static struct strexpr *new_expr PROTO_ARGS((char *, char *, struct strterm *));
static struct strlist *new_elem PROTO_ARGS((char *));
static struct strevent *new_event PROTO_ARGS((struct strterm *, struct strexpr *));
static struct strlist *append_list PROTO_ARGS((struct strlist *, char *));
static struct streventlist *append_eventlist PROTO_ARGS((struct streventlist *, struct strevent *));
static struct strtermlist *append_termlist PROTO_ARGS((struct strtermlist *, struct strterm *));
void new_iwtable PROTO_ARGS((struct strlist *, struct streventlist *));

/*
#undef yyerror(x)
*/
#define yyerror(x) errordet(yystate)

void on_syntax_err()
{
}

%}

%start	iw_table

%union {
    char *literal;
    struct strlist *list;
    struct streventlist *eventlist;
    struct strevent *event;
    struct strexpr *expr;
    struct strterm *term;
    struct strtermlist *termlist;
}

%token	INSTANCES EVENTS ARROW
%token	<literal>	PSF_IDENTIFIER PSF_OPERATOR
%token	<literal>	IDENTIFIER
%token	<literal>	PLACEHOLDER

%type	<list>		inst_decl
%type	<list>		instance_list
%type	<eventlist>	events
%type	<eventlist>	event_list
%type	<event>		event
%type	<expr>		expression
%type	<expr>		action
%type	<expr>		communication
%type	<term>		psf_term
%type	<termlist>	psf_arglist
%type	<term>		psf_primary
%type	<term>		psf_argument
%type	<term>		term
%type	<termlist>	arglist
%type	<term>		argument
%type	<literal>	inst_id

%%
iw_table :
    inst_decl events {
	new_iwtable($1, $2);
	YYACCEPT;
    }
;

inst_decl :
    INSTANCES instance_list {
	$$ = $2;
    }
;

instance_list :
    inst_id {
	$$ = new_elem($1);
    }
|   instance_list ',' inst_id {
	$$ = append_list($1, $3);
    }
;

events :
    EVENTS {
	begin_psf();
    } event_list {
	$$ = $3;
    }
;

event_list :
    /* empty */ {
	$$ = NULL;
    }
|   event_list event {
	$$ = append_eventlist($1, $2);
    }
;

event :
    psf_term {
	end_psf();
    } ARROW expression
    {
	$$ = new_event($1, $4);
	begin_psf();
    }
;

expression :
    action {
	$$ = $1;
    }
|   communication {
	$$ = $1;
    }
;

action :
    '{' inst_id ',' term '}' {
	$$ = new_expr($2, NULL, $4);
    }
;

communication :
    '{' inst_id ',' inst_id ',' term '}' {
	$$ = new_expr($2, $4, $6);
    }
;

psf_term :
    PSF_IDENTIFIER {
	$$ = new_term($1, NULL);
    }
|   PSF_IDENTIFIER '(' psf_arglist ')' {
	$$ = new_term($1, $3);
    }
;

psf_arglist :
    psf_argument {
	$$ = new_termlist($1);
    }
|   psf_arglist ',' psf_argument {
	$$ = append_termlist($1, $3);
    }
;

psf_argument :
    psf_primary {
	$$ = $1;
    }
|   psf_argument PSF_OPERATOR psf_primary {
	$$ = new_term($2, append_termlist(new_termlist($1), $3));
    }
;

psf_primary :
    psf_term {
	$$ = $1;
    }
|   PSF_OPERATOR psf_primary {
	$$ = new_term($1, new_termlist($2));
    }
|   '(' psf_argument ')' {
	$$ = $2;
    }
|   PLACEHOLDER {
	$$ = new_term($1, NULL);
    }
;

term :
    IDENTIFIER {
	$$ = new_term($1, NULL);
    }
|   IDENTIFIER '(' arglist ')' {
	$$ = new_term($1, $3);
    }
;

arglist :
    argument {
	$$ = new_termlist($1);
    }
|   arglist ',' argument {
	$$  = append_termlist($1, $3);
    }
;

argument :
    term {
	$$ = $1;
    }
|   PLACEHOLDER {
	$$ = new_term($1, NULL);
    }
;

inst_id :
    IDENTIFIER {
	$$ = $1;
    }
|   PLACEHOLDER {
	$$ = $1;
    }
;

%%

/*
static void yyerror(s)
char *s;
{
    fprintf(stderr, "line %d: %s\n", line, s);
}
*/

static struct strterm *new_term(id, list)
char *id;
struct strtermlist *list;
{
    struct strterm *t;
    struct strtermlist *h;

    t = PSF_MALLOC(struct strterm);
    t->id = id;
    t->list = list;
    for (t->a = 0, h = list; h != NULL; t->a ++, h = h->next);
    return(t);
}

static struct strtermlist *new_termlist(term)
struct strterm *term;
{
    struct strtermlist *t;

    t = PSF_MALLOC(struct strtermlist);
    t->term = term;
    t->next = NULL;
    return(t);
}

static struct strexpr *new_expr(p1, p2, term)
char *p1;
char *p2;
struct strterm *term;
{
    struct strexpr *e;

    e = PSF_MALLOC(struct strexpr);
    e->p1 = p1;
    e->p2 = p2;
    e->term = term;
    return(e);
}

static struct strlist *new_elem(name)
char *name;
{
    struct strlist *l;

    l = PSF_MALLOC(struct strlist);
    l->name = name;
    l->next = NULL;
    return(l);
}

static struct strevent *new_event(term, expr)
struct strterm *term;
struct strexpr *expr;
{
    struct strevent *e;

    e = PSF_MALLOC(struct strevent);
    e->term = term;
    e->expr = expr;
    return(e);
}

static struct strlist *append_list(list, name)
struct strlist *list;
char *name;
{
    struct strlist *l, *h;

    l = new_elem(name);
    if (list == NULL)
	return(l);
    for (h = list; h->next != NULL; h = h->next);
    h->next = l;
    return(list);
}

static struct streventlist *append_eventlist(list, event)
struct streventlist *list;
struct strevent *event;
{
    struct streventlist *l, *h;

    l = PSF_MALLOC(struct streventlist);
    l->event = event;
    l->next = NULL;
    if (list == NULL)
	return(l);
    for (h = list; h->next != NULL; h = h->next);
    h->next = l;
    return(list);
}

static struct strtermlist *append_termlist(list, term)
struct strtermlist *list;
struct strterm *term;
{
    struct strtermlist *t, *h;

    t = new_termlist(term);
    if (list == NULL)
	return(t);
    for (h = list; h->next != NULL; h = h->next);
    h->next = t;
    return(list);
}

void new_iwtable(list, eventlist)
struct strlist *list;
struct streventlist *eventlist;
{
    iwtable = PSF_MALLOC(struct striwtable);
    iwtable->instances = list;
    iwtable->events = eventlist;
}
