%{
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "y.tab.h"

#ifdef FLEX_SCANNER
int yywrap PROTO_ARGS((void))
{
    return(1);
}
#endif /* FLEX_SCANNER */

static void set_yylval PROTO_ARGS((void));
int line = 1;

%}

letter		[a-zA-Z\']
digit		[0-9]
psf_symbol	[!@$%\^&+\*;?~/|\\+-]
symbol		[!@$%\^&+\*;?~/|\\'`#_+=\[\]<>.:"]

psf_identifier	({letter}|{digit})(({letter}|{digit}|-)*({letter}|{digit}))?
identifier	{letter}({letter}|{digit}|{symbol})*
psf_operator	{psf_symbol}+|(\.{psf_identifier}\.)
placeholder	_{digit}+

%Start psf

%%
"instances"	return(INSTANCES);
"events"	return(EVENTS);
"->"		return(ARROW);

<psf>{psf_identifier} {
	set_yylval();
	return(PSF_IDENTIFIER);
    }
<psf>{psf_operator} {
	set_yylval();
	return(PSF_OPERATOR);
    }
{identifier} {
	set_yylval();
	return(IDENTIFIER);
    }
{placeholder} {
	set_yylval();
	return(PLACEHOLDER);
    }

[ \t]		;
\n		line ++;

.		return(yytext[0]);
%%
static void set_yylval()
{
    yylval.literal = psf_strdup(yytext);
}

void begin_psf()
{
    BEGIN psf;
}

void end_psf()
{
    BEGIN 0;
}
