.TH "IWTABLE.BNF" 5 "Mar 22, 1995" "PSF-Toolkit" "FILE FORMATS"
.SH NAME
iwtable.bnf \- Backus Naur Form description of an interworking
translation table
.SH DESCRIPTION
The following describes an interworking translation table as accepted
by the
.B -i
option of
.BR traceview (1L).
.SS Syntax
The items below may be separated by whitespace.
.PP
.nf
.ta +1.6i +0.5i
<iw_table>	::=	<inst_decl> <events>

<inst_decl>	::=	'instances' { <inst_id> ',' }+

<events>	::=	'events' <event>*

<event>	::=	<psf_term> '->' ( <action> | <communication> )

<action>	::=	'{' <inst_id> ',' <term> '}'

<communication>	::=	'{' <inst_id> ',' <inst_id> ',' <term> '}'

<psf_term>	::=	<psf_id>
	|	<psf_id> '(' { <psf_argument> ',' }+ ')'

<psf_argument>	::=	<psf_primary>
	|	<psf_argument> <psf_operator> <psf_primary>

<psf_primary>	::=	<psf_term>
	|	<psf_operator> <psf_primary>
	|	'(' <psf_argument> ')'
	|	<placeholder>

<term>	::=	<id>
	|	<id> '(' { <argument> ',' }+ ')'

<argument>	::=	<term>
	|	<placeholder>

.fi
.SS Lexical Syntax
The items below may not be separated by whitespace.
.PP
.nf
<placeholder>	::=	'_' <digit>+

<inst_id>	::=	<id> | <placeholder>

<psf_id>	::=	( <letter> | <digit> )
		[ ( <letter> | <digit> | '-' )*
		( <letter> | <digit> ) ]

<id>	::=	<letter> ( <letter> | <digit> | <symbol> )*

<psf_operator>	::=	<psf_symbol>+
	|	'.' <psf_id> '.'

<letter>	::=	'a'-'z' | 'A'-'Z' | '''

<digit>	::=	'0'-'9'

<psf_symbol>	::=	'!' | '@' | '$' | '%' | '^' | '&' | '*' | ';' |
		'?' | '~' | '/' | '|' | '\\' | '+' | '-'

<symbol>	::=	'!' | '@' | '$' | '%' | '^' | '&' | '*' | ';' |
		'?' | '~' | '/' | '|' | '\\' | '+' |
		''' | '`' | '#' | '_' | '=' | '[' | ']' |
		'<' | '>' | '.' | ':' | '"'
.fi
.SH SEE ALSO
.BR traceview (1L)
.SH AUTHOR
Bob Diertens, University of Amsterdam (bobd@fwi.uva.nl)
