#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "main.h"
#include "iwtabletype.h"

static int error;

static int e_nr; /* event number */

static struct strlist *new_elem(name)
char *name;
{
    struct strlist *l;

    l = PSF_MALLOC(struct strlist);
    l->name = name;
    l->next = NULL;
    return(l);
}

static struct strlist *append_list(list, name)
struct strlist *list;
char *name;
{
    struct strlist *l, *h;

    l = new_elem(name);
    if (list == NULL)
        return(l);
    for (h = list; h->next != NULL; h = h->next);
    h->next = l;
    return(list);
}

static struct strlist *make_placeholder_list(t, l)
struct strterm *t;
struct strlist *l;
{
    int i;
    struct strtermlist *tl;

    if (t->id[0] == '_') {
	return(append_list(l, t->id));
    }
    for (i = 0, tl = t->list; i < t->a; i ++, tl = tl->next) {
	l = make_placeholder_list(tl->term, l);
    }
    return(l);
}

static void free_placeholder_list(l)
struct strlist *l;
{
    struct strlist *h;

    while (l != NULL) {
	h = l;
	l = l->next;
	PSF_FREE(h);
    }
}

static int name_in_list(n, l)
char *n;
struct strlist *l;
{
    struct strlist *h;

    for (h = l; h != NULL; h = h->next) {
	if (!strcmp(n, h->name))
	    return(1);
    }
    return(0);
}

static void check_process_names(e, l)
struct strexpr *e;
struct strlist *l;
{
    if (*(e->p1) != '_' && !name_in_list(e->p1, l)) {
	fprintf(stderr, "%s: Error in event %d: '%s' is not an instance\n",
	    progname, e_nr, e->p1);
	error ++;
    }
    if (e->p2 != NULL && *(e->p2) != '_' && !name_in_list(e->p2, l)) {
	fprintf(stderr, "%s: Error in event %d: '%s' is not an instance\n",
	    progname, e_nr, e->p2);
	error ++;
    }
}

static void check_placeholders(t, l)
struct strterm *t;
struct strlist *l;
{
    int i;
    struct strtermlist *tl;

    if (t->id[0] == '_') {
	if (!name_in_list(t->id, l)) {
	    fprintf(stderr, "%s: Error in event %d: placeholder '%s' does not appear in the psf-term\n",
		progname, e_nr, t->id);
	    error ++;
	}
	return;
    }
    for (i = 0, tl = t->list; i < t->a; i ++, tl = tl->next) {
	check_placeholders(tl->term, l);
    }
}

int check_iwtable(iwt)
struct striwtable *iwt;
{
    struct strlist *pl;
    struct streventlist *el;
    struct strevent *e;
    struct strlist *phl;

    error = 0;
    pl = iwt->instances;
    e_nr = 0;
    for (el = iwt->events; el != NULL; el = el->next) {
	e_nr ++;
	e = el->event;
	phl = make_placeholder_list(e->term, NULL);
	check_process_names(e->expr, pl);
	check_placeholders(e->expr->term, phl);
	free_placeholder_list(phl);
    }
    return(error);
}
