
unit module BTCA;

my $DEBUG = False;

our sub debug($d) {
    $DEBUG = $d;
}

class Channel {
    has $.id;
    has @.channel;

    method new($id) {
        my @channel;
        push @channel, CORE::Channel.new;
        push @channel, CORE::Channel.new;
        self.bless(:$id, :@channel);
    }

    method snd-msg($s) {
        my $ack;
        if $DEBUG { say "TCA chan snd ", $!id, " : $s"; }
        @!channel[0].send($s);
        $ack = @!channel[1].receive;
        if $DEBUG { say "TCA chan $ack "; }
    }

    method rec-msg (:$block = False) {
        if $block {
            my $r;
            $r = @!channel[0].receive;
            self!ackout($r);
            return $r;
        } else {
            supply whenever @!channel[0] {
                self!ackout($_);
                .emit; # equals self.emit and $_.emit, but emit of what?
            }
        }
    }

    method !ackout($s) {
        @!channel[1].send("$!id sync: $s");
    }
        
}

my @toollist = ();

class Tool is Proc::Async {
    has $.id;
    has $.tool;
    has $.channel;

    method new($id, $path, *@args) {
        my $t = Proc::Async.new(:w, $path, @args);
        my $c = $t.stdout.lines.Channel();
        self.bless(:$id, tool => $t, channel => $c);
    }

    method Start($me:) {
        push @toollist, $me;
        $!tool.start;
    }

    method Receive(:$block = False) {

        if $block {
            my $r;
            $r = $!channel.receive;
            return $r;
        } else {
            supply whenever $!channel {
                my $s = chomp $_;
                if $DEBUG { say "TCA " ~ $!id ~ " receive: $s"; }
                emit($s);
            }
        }
    }
            
    method Send($s) {
        $!tool.say($s);
        if $DEBUG { say "TCA " ~ $!id ~ " send: $s"; }
    }

    method Kill() {
        if $DEBUG { say "TCA tool $!id killed"; }
        $!tool.kill();
    }

}

our %expr = Map.new(
    'rec-event', /^snd\-event\((.+)\)$/,
    'rec-value', /^snd\-value\((.+)\)$/,
);

my @processlist = ();

our sub Run(*@funcs) {
    my $p;
    my $f;

    for @funcs -> $f {
        $p = start $f();
        push @processlist, $p;
    }
    await @processlist;
}

our sub Shutdown($m) {
    my $t;

    for @toollist -> $t {
        # $t.snd-terminate($m);
        # or
        $t.Kill();
    }
    exit(0);
}

