
namespace eval Process {
    variable choose
    variable chooselist
    variable callback
    variable listinfo

    package provide Process 0.0
    package require ComboBox
}

proc Process::Init {path func} {
    variable process
    variable callback
    variable select

    set process $path
    set callback $func

    frame $process
    pack $process

    frame $process.select
    pack $process.select
    ComboBox::Create $process.select.e 16 0 Process::Select
    button $process.select.start -bd 1 -width 9 -text "(re)start" -command Process::This -takefocus 0
    pack $process.select.e -in $process.select -side left
    pack $process.select.start -in $process.select -side left -padx 4
    frame $process.current
    pack $process.current
    label $process.current.t -text "current"
    label $process.current.p -bd 1 -relief sunken -width 16  -anchor w -text ""
    pack $process.current.t $process.current.p -in $process.current -side left
    pack $process.select $process.current -in $process -anchor w

    set select ""
}

proc Process::Add {item} {
    variable process
    variable select

    ComboBox::Add $process.select.e $item
    if {$select == ""} {
	ComboBox::Set $process.select.e $item
	ComboBox::SetEntryIndex $process.select.e 0
    }
}

proc Process::Select {p} {
    variable select

    set select $p
}

proc Process::This {} {
    variable callback
    variable select
    variable process

    $callback [ComboBox::GetEntryIndex $process.select.e] $select
    $process.current.p configure -text $select
}

proc Process::Choose {p} {
    variable process

    if {[ComboBox::Set $process.select.e $p]} {
	Process::This
	return 1
    }
    return 0
}
