namespace eval Pane {
    package provide Pane 0.0

}

proc Pane::Create {f1 f2 args} {
   ### Map optional arguments into array values ###
   set t(-orient) horizontal
   set t(-percent) 0.5
   set t(-in) [winfo parent $f1]
   array set t $args
    if {! [info exists t(-background)]} {
	set t(-background) [lindex [$t(-in) configure -background] 3]
    }

   ### Keep state in an array associated with the master frame ###
   set master $t(-in)
   pack $master -expand true -fill both
   pack propagate $master off
   upvar #0 [namespace current]::Pane$master pane
   array set pane [array get t]

   set pane(1) $f1
   set pane(2) $f2
   set pane(grip) $master.grip

   if {[string match vert* $pane(-orient)]} {
       frame $pane(grip) -class PaneGrip -background $pane(-background) -bd 1 -relief raised -height 2
       ### Adjust boundary in Y direction ###
       set pane(D) Y
       place $pane(1) -in $master -x 0 -rely 0.0 -anchor nw -relwidth 1.0 -height -2
       place $pane(2) -in $master -x 0 -rely 1.0 -anchor sw -relwidth 1.0 -height -2
       place $pane(grip) -in $master -relwidth 1 -x 0 -anchor w -height 4
       $pane(grip) configure -cursor sb_v_double_arrow

   } else {
       frame $pane(grip) -class PaneGrip -background $pane(-background) -bd 1 -relief raised -width 2
       ### Adjust boundary in X direction ###
       set pane(D) X
       place $pane(1) -in $master -relx 0.0 -y 0 -anchor nw -relheight 1.0 -width -2
       place $pane(2) -in $master -relx 1.0 -y 0 -anchor ne -relheight 1.0 -width -2
       place $pane(grip) -in $master -relheight 1 -y 0 -anchor n -width 4
       $pane(grip) configure -cursor sb_h_double_arrow
   }

    if {! [info exists t(-activebackground)]} {
	set pane(-activebackground) [option get $pane(grip) activeBackground PaneGrip]
    }

   ### bindings for resize AKA <Configure>, and dragging the grip. ###
   bind $master     <Configure>       [namespace code [list  Geometry $master]]
   bind $pane(grip) <B1-Motion>       [namespace code [list  Drag $master %$pane(D)]]
   bind $pane(grip) <ButtonRelease-1> [namespace code [list  Stop $master]]

    bind $pane(grip) <Enter> "$pane(grip) configure -background $pane(-activebackground)"
    bind $pane(grip) <Leave> "$pane(grip) configure -background $pane(-background)"

   ### Do the initial layout ###
   Geometry $master
}

proc Pane::Set {master value} {
   set [namespace current]::Pane${master}(-percent) $value
   Geometry $master
}

proc Pane::Drag {master D} {
   upvar #0 [namespace current]::Pane$master pane
   if [info exists pane(lastD)] {
       set delta [expr {double($pane(lastD)-$D)/$pane(size)}]
       set pane(-percent) [expr {$pane(-percent) - $delta}]
       if {$pane(-percent) < 0.0} {
	   set pane(-percent) 0.0
       } elseif {$pane(-percent) > 1.0} {
	   set pane(-percent) 1.0
       }
       Geometry $master
   }
   set pane(lastD) $D
}

proc Pane::Stop {master} {
   upvar #0 [namespace current]::Pane$master pane
   catch {unset pane(lastD)}
}

proc Pane::Geometry {master} {
   upvar #0 [namespace current]::Pane$master pane

   if {$pane(D) == "X"} {
       place $pane(1) -relwidth $pane(-percent)
       place $pane(2) -relwidth [expr {1.0 - $pane(-percent)}]
       place $pane(grip) -relx $pane(-percent)
       set pane(size) [winfo width $master]

   } else { # $pane(D) == "Y"
       place $pane(1) -relheight $pane(-percent)
       place $pane(2) -relheight [expr {1.0 - $pane(-percent)}]
       place $pane(grip) -rely $pane(-percent)
       set pane(size) [winfo height $master]
   }
}
