
namespace eval History {
    variable id
    variable max_id
    variable buttons
    variable mark
    variable history_move
    variable callback

    package provide History 0.0
}

proc History::DeleteFuture {} {
    variable id
    variable max_id
    variable button
    variable mark

    set max_id $id
    $button(redo) configure -state disabled
    foreach m [array names mark] {
	if {$mark($m) >= $id} {
	    ComboBox::DeleteEntry $button(goto).e $m
	    unset mark($m)
	}
    }
    if {[array size mark] == 0} {
	ComboBox::State $button(goto).e disabled
	$button(goto).b configure -state disabled
    }
}

proc History::Reset {} {
    variable id
    variable max_id
    variable history_move

    set id -1
#    if {$max_id >= 0} {
#	set history_move 1
#    }
    History::DeleteFuture
    History::Disable
    History::Enable
}

proc History::Save {} {
    variable id
    variable max_id
    variable button
    variable history_move
    variable mark
    variable callback

    if {$history_move} {
	set history_move 0
	return
    }
    incr id
    if {$id > $max_id} {
	set max_id $id
    } else {
	# no future
	History::DeleteFuture
    }
    $callback(save) $id
    if {$id > 0} {
	$button(undo) configure -state normal
    }
    if {$id >= 0} {
	$button(mark).b configure -state normal
	$button(mark).e configure -state normal
    }
}

proc History::Undo {} {
    variable id
    variable button
    variable history_move
    variable callback

    incr id -1
    $callback(goto) $id
    if {$id == 0} {
	$button(undo) configure -state disabled
    }
    $button(redo) configure -state normal
    set history_move 1
}

proc History::Redo {} {
    variable id
    variable max_id
    variable button
    variable history_move
    variable callback

    incr id
    $callback(goto) $id
    if {$id == $max_id} {
	$button(redo) configure -state disabled
    }
    $button(undo) configure -state normal
    set history_move 1
}

proc History::Mark {} {
    variable id
    variable mark
    variable button

    set v [$button(mark).e get]
    if {$v == ""} {
	return
    }
    if {[array get mark $v] == ""} {
	ComboBox::Add $button(goto).e $v
    }
    set mark($v) $id
    if {[array size mark] > 0} {
	ComboBox::State $button(goto).e normal
	$button(goto).b configure -state normal
    }
    $button(mark).e configure -state normal
}

proc History::Goto {} {
    variable id
    variable max_id
    variable mark
    variable button
    variable history_move
    variable callback

    set v [ComboBox::GetEntry $button(goto).e]
    if {$v == ""} {
	return
    }
    set id $mark($v)
    $callback(goto) $id
    set history_move 1
    if {$id == 0} {
	$button(undo) configure -state disabled
    } else {
	$button(undo) configure -state normal
    }
    if {$id == $max_id} {
	$button(redo) configure -state disabled
    } else {
	$button(redo) configure -state normal
    }
}

proc History::Init {w save goto} {
    variable button
    variable id
    variable max_id
    variable history_move
    variable callback

    set callback(save) $save
    set callback(goto) $goto
    frame $w -bd 1 -relief raised
    pack $w
    label $w.t -text "History"
    pack $w.t -in $w -side top
    frame $w.l
    pack $w.l
    button $w.l.undo -bd 1 -text "Undo" -command { History::Undo } -state disabled -takefocus 0
    button $w.l.redo -bd 1 -text "Redo" -command { History::Redo } -state disabled -takefocus 0
    set button(undo) $w.l.undo
    set button(redo) $w.l.redo
    pack $w.l.undo $w.l.redo -in $w.l -side top
    frame $w.r
    pack $w.r
    frame $w.r.mark
    pack $w.r.mark
    button $w.r.mark.b -bd 1 -text "Mark" -command { History::Mark } -state disabled -takefocus 0
    set button(mark) $w.r.mark
    entry $w.r.mark.e -bd 1 -width 8 -takefocus 1 -state disabled -highlightthickness 0
    pack $w.r.mark.b -in $w.r.mark -side left
    pack $w.r.mark.e -in $w.r.mark -side left -padx 4
    pack $w.r.mark -in $w.r -side top -anchor w
    frame $w.r.goto
    pack $w.r.goto
    button $w.r.goto.b -bd 1 -text "Goto" -command { History::Goto } -state disabled -takefocus 0
    set button(goto) $w.r.goto
#    entry $w.r.goto.e -width 8
    ComboBox::Create $w.r.goto.e 8 0 {}
    pack $w.r.goto.b -in $w.r.goto -side left
    pack $w.r.goto.e -in $w.r.goto -side left -padx 4
    pack $w.r.goto -in $w.r -side top

    pack $w.l $w.r -in $w -side left -padx 2 -pady 2

    set id -1
    set max_id -1
    set history_move 0
}

proc History::Disable {} {
    variable button

    $button(undo) configure -state disabled
    $button(redo) configure -state disabled
    $button(mark).b configure -state disabled
    $button(mark).e configure -state disabled
    $button(goto).b configure -state disabled
    ComboBox::State $button(goto).e disabled
}

proc History::Enable {} {
    variable button
    variable id
    variable max_id
    variable mark

    if {$id > 0} {
	$button(undo) configure -state normal
    }
    if {$id < $max_id} {
	$button(redo) configure -state normal
    }
    if {$id >= 0} {
	$button(mark).b configure -state normal
	$button(mark).e configure -state normal
    }
    if {[array size mark] > 0} {
	$button(goto).b configure -state normal
	ComboBox::State $button(goto).e normal
    }
}

