
# package ComboBox - Combination of an entry widget with a choose-list
#
# author: Bob Diertens
#
# version: 0.3
# date: JUly 18, 2007
#    Several bugfixes.
#    Smaller images and smaller borders.
#
# version: 0.2
# date: April 17, 2002
#    Added SetEntry (Set but no callback).
#    Added State for disabled/normal state.
#
# version: 0.1
# date: November 17, 1999
#    The callback is called on a Leave from the entry widget.
#
# version: 0.0
# date: February 26, 1999

namespace eval ComboBox {
    variable combo
    variable combo_down
    variable combo_up
    namespace export Create
    package provide ComboBox 0.3

    image create bitmap combo_down -data {
	    #define down_width 12
	    #define down_height 16
	    static unsigned char down_bits[] = {
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x03,0xf8,0x01,
		0xf0,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x03,
		0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00
	    }
	}
    image create bitmap combo_up -data {
	    #define up_width 12
	    #define up_height 16
	    static unsigned char up_bits[] = {
	    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x03,0xfc,0x03,
	    0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0xf0,0x00,0xf8,0x01,
	    0xfc,0x03,0x00,0x00,0x00,0x00,0x00,0x00
	}
	}
}

proc ComboBox::Create {Wid width editable callback} {
    variable combo
    variable combo_down

    frame $Wid -relief sunken -bd 1 -highlightthickness 0
    pack $Wid

    set combo($Wid,edit) $editable
    entry $Wid.e -width $width -textvariable ComboBox::combo($Wid,entry) \
	-highlightthickness 0 -bd 0 -takefocus $editable
    button $Wid.b -image combo_down -relief raised -bd 1 \
	-command " ComboBox::list-popup $Wid " \
	-height 12 -width 10 -highlightthickness 0 -anchor w \
	-state disabled -disabledforeground gray70
    pack $Wid.e $Wid.b -in $Wid -side left -fill y

    set top "$Wid.top"
    set combo($Wid,list) $top.f.lb
    set combo($Wid,frame) $top.f
    set combo($top.f.lb,combo) $Wid
    set combo($Wid,scroll) $top.f.sb
    set combo($Wid,editable) $editable
    set combo($Wid,callback) $callback
    set combo($Wid,entries) ""
    set combo($Wid,selectindex) -1
    toplevel $top -takefocus 1 -cursor top_left_arrow -bd 1 -background black
    wm withdraw $top
    wm overrideredirect $top 1

    frame $top.f -relief raised -bd 1 -takefocus 0
    pack $top.f
    listbox $top.f.lb -width $width -height 1 -bd 1 -relief sunken \
	-highlightthickness 0 -yscrollcommand "$top.f.sb set" -takefocus 0
    scrollbar $top.f.sb -orient vertical -bd 1 -highlightthickness 0 -width 10 \
	-command "$top.f.lb yview" -takefocus 0

    pack $top.f.lb $top.f.sb -in $top.f -side left -fill y
    pack $top.f -in $top
    pack forget $top.f.sb

    set parent [winfo parent $top]
    bind $Wid <Any-ButtonPress> { ComboBox::list-popdown %W }
    bind $Wid <Any-ButtonRelease> { ComboBox::list-popdown %W }
    bind $top.f.lb <ButtonRelease-1> " 
	    ComboBox::list-select %W %x %y
	    ComboBox::callback $Wid
	"
    bind $top.f.lb <ButtonRelease-1> {+
		focus [tk_focusNext $ComboBox::combo(%W,combo).e]
	}
    bind $top.f.lb <Any-Motion> {
	    %W selection clear 0 end
	    %W activate @%x,%y
	    %W selection anchor @%x,%y
	    %W selection set @%x,%y @%x,%y
	    # need to do a yview if the cursor goes off the top
	    # or bottom of the window... (or do we?)
	}
    if {$editable} {
	bind $top <FocusIn> [list focus $Wid.e]
	bind $Wid.e <Leave> "
		ComboBox::callback $Wid
	    "
	bind $Wid.e <Any-KeyPress> [list ComboBox::list-popdown $Wid]
	bind $Wid.e <Return> "
		ComboBox::list-popdown $Wid
		ComboBox::callback $Wid
	    "
	bind $Wid.e <Tab> "
		ComboBox::list-popdown $Wid
		ComboBox::callback $Wid
	    "
	bind $Wid.e <Shift-Tab> "
		ComboBox::list-popdown $Wid
		ComboBox::callback $Wid
	    "
	bind $Wid.e <Return> {+
		focus [tk_focusNext %W]
	    }
    } else {
	bind $Wid.e <Any-KeyPress> { break }
	bind $Wid.e <Any-ButtonRelease> { break }
	bind $Wid.e <Any-ButtonPress> { break }
    }
}

proc ComboBox::list-popup {w} {
    variable combo_up
    variable combo

    if {[winfo ismapped $w.top]} {
	ComboBox::list-popdown $w
	return;
    }
    set top $w.top
    set X [expr ([winfo rootx $w.e] % [winfo screenwidth .]) - 3]
    set Y [expr ([winfo rooty $w.e] % [winfo screenheight .]) + [winfo height $w.e] + 2]
    wm geometry $top +$X+$Y
    wm deiconify $top
    tkwait visibility $top
    raise $top
    grab -global $w
    if {$combo($w,editable)} {
	focus -force $w.e
    }
    $w.b configure -image combo_up
}

proc ComboBox::list-popdown {w} {
    variable combo_down

    grab release $w
    update
    wm withdraw $w.top
    $w.b configure -image combo_down
}

proc ComboBox::list-select {w x y} {
    variable combo
    set index [$w nearest $y]
    set bbox [$w bbox $index]
    set ex [lindex $bbox 0]
    set ey [lindex $bbox 1]
    set ew [winfo width $w]
    set eh [lindex $bbox 3]
    if {$x < $ex || $x > [expr $ex + $ew] ||
	$y < $ey || $y > [expr $ey + $eh]} {
	$w selection clear 0 end
	return;
    }
    set Wid $combo($w,combo)
    $Wid.e delete 0 end
    $Wid.e insert end [$w get $index]
    ComboBox::list-popdown $Wid
    set combo($Wid,selectindex) $index
}

proc ComboBox::Add {Wid e} {
    variable combo

    set w $combo($Wid,list)
    $w insert end $e
    if {[$w size] < 6} {
	$w configure -height [$w size]
	if {[$w size] == 2} {
	    pack $combo($Wid,scroll) -in $combo($Wid,frame) -side left -fill y
	}
    }
    $Wid.b configure -state normal
    $Wid.b configure -takefocus 0
    lappend combo($Wid,entries) $e
}

proc ComboBox::Delete {Wid nr} {
    variable combo

    set w $combo($Wid,list)
    $w delete $nr $nr
    if {[$w size] < 6} {
	$w configure -height [$w size]
	if {[$w size] == 1} {
	    pack forget $combo($Wid,scroll)
	}
	if {[$w size] == 0} {
	    $Wid.b configure -state disabled
	    $Wid.b configure -takefocus 1
	}
    }
    set combo($Wid,entries) [lreplace $combo($Wid,entries) $nr $nr]
    if {$combo($Wid,selectindex) == $nr} {
	set combo($Wid,entry) ""
	set combo($Wid,selectindex) -1
    }
}

proc ComboBox::index-entries {Wid v} {
    variable combo

    return [lsearch -exact $combo($Wid,entries) $v]
}

proc ComboBox::AddNew {Wid e} {
    variable combo

    if {[ComboBox::index-entries $Wid $e] == -1} {
	ComboBox::Add $Wid $e
	return 1
    }
    return 0
}

proc ComboBox::DeleteEntry {Wid s} {
    variable combo

    set e [ComboBox::index-entries $Wid $s]
    if {$e != -1} {
	ComboBox::Delete $Wid $e
	return 1
    }
    return 0
}
proc ComboBox::DeleteAll {Wid} {
    variable combo

    set w $combo($Wid,list)
    $w delete 0 end
    $w configure -height 0
    set combo($Wid,entries) ""
    set combo($Wid,entry) ""
    set combo($Wid,selectindex) -1
    $Wid.b configure -state disabled
    $Wid.b configure -takefocus 1
    pack forget $combo($Wid,scroll)
}

proc ComboBox::Set {Wid v} {
    variable combo

    set i [ComboBox::index-entries $Wid $v]
    if {$i == -1} {
	return 0
    }
    set combo($Wid,entry) "$v"
    set combo($Wid,selectindex) $i
    ComboBox::callback $Wid
    return 1
}

proc ComboBox::SetEntry {Wid v} {
    variable combo

    set i [ComboBox::index-entries $Wid $v]
    if {$i == -1} {
	return 0
    }
    set combo($Wid,entry) "$v"
    set combo($Wid,selectindex) $i
    return 1
}

proc ComboBox::GetEntry {Wid} {
    variable combo

    return $combo($Wid,entry)
}

proc ComboBox::SetEntryIndex {Wid i} {
    variable combo

    if {[llength $combo($Wid,entries)] <= $i} {
	return 0
    }
    set combo($Wid,selectindex) $i
    return 1
}

proc ComboBox::GetEntryIndex {Wid} {
    variable combo

    return $combo($Wid,selectindex)
}

proc ComboBox::callback {w} {
    variable combo

    set value [ComboBox::GetEntry $w]
    if {$combo($w,callback) != ""} {
	$combo($w,callback) $value
    }
}

proc ComboBox::State {Wid state} {
    variable combo

    if {$state == "normal"} {
	if {[$combo($Wid,list) size] > 0} {
	    $Wid.b configure -state normal
	}
	$Wid.e configure -state normal
    } else { # disabled
	$Wid.b configure -state disabled
	if {$combo($Wid,edit)} {
	    $Wid.e configure -state disabled
	}
    }
}
