
namespace eval Choose {
    variable choose
    variable chooselist
    variable callback
    variable listinfo

    package provide Choose 0.1
}

proc Choose::Init {path func {selectmode browse}} {
    variable choose
    variable chooselist
    variable callback
    variable listinfo
    variable color

    set choose $path
    set callback $func

    frame $choose
    pack $choose

    frame $choose.f -bd 0
    pack $choose.f -in $choose
    set chooselist $choose.f.list
    listbox $chooselist -bd 1 -highlightthickness 0 -width 16 -height 16 \
	-selectmode $selectmode -takefocus 0 \
	-xscrollcommand "$choose.xs set" -yscrollcommand "$choose.ys set"
    pack $chooselist -in $choose.f -expand 1 -fill both -padx 0 -pady 0
    scrollbar $choose.xs -orient horizontal -width 8 -highlightthickness 0 \
	-takefocus 0 -command "$chooselist xview" -bd 1
    scrollbar $choose.ys -orient vertical -width 8 -highlightthickness 0 \
	-takefocus 0 -command "$chooselist yview" -bd 1
    grid $choose.f -row 0 -column 0 -rowspan 1 -columnspan 1 -sticky news \
	-padx 0 -pady 0
    grid $choose.ys -row 0 -column 1 -rowspan 1 -columnspan 1 -sticky ns \
	-padx 0 -pady 0
    grid $choose.xs -row 1 -column 0 -rowspan 1 -columnspan 1 -sticky ew \
	-padx 0 -pady 0
    grid rowconfig $choose 0 -weight 1 -minsize 0
    grid rowconfig $choose 1 -weight 0
    grid columnconfig $choose 0 -weight 1 -minsize 0
    grid columnconfig $choose 1 -weight 0

    bind $chooselist <ButtonRelease-1> { Choose::This %y }
    set listinfo(height) 0
    set listinfo(width) 0

    set color(fg) [$chooselist cget -foreground]
    set color(bg) [$chooselist cget -background]
}

proc Choose::Add {item} {
    variable chooselist
    variable listinfo

    $chooselist insert end $item
    incr listinfo(height)
    if {[string length $item] > $listinfo(width)} {
	set listinfo(width) [string length $item]
    }
}

proc Choose::DeleteAll {} {
    variable chooselist
    variable listinfo

    $chooselist delete 0 end
    set listinfo(height) 0
    set listinfo(width) 0
}

proc Choose::This {y} {
    variable chooselist
    variable callback

    set i [$chooselist nearest $y]
    set coor [$chooselist bbox $i]
    if {$y >= [expr [lindex $coor 1] - 2] && $y < [expr [lindex $coor 1] + [lindex $coor 3] + 2]} {
	set choice [$chooselist get $i]
	$callback $i $choice
    }
}

proc Choose::Resize {} {
    variable chooselist
    variable listinfo

    set w 24
    if {$listinfo(width) < $w} {
	set w $listinfo(width)
    }
    set h 16
    if {$listinfo(height) < $h} {
	set h $listinfo(height)
    }
    $chooselist configure -width $w -height $h
}

proc Choose::Random {} {
    variable chooselist
    variable listinfo
    variable callback

    set i [expr int($listinfo(height) * rand())]
    set choice [$chooselist get $i]
    $callback $i $choice
}

proc Choose::Select {i} {
    variable chooselist
    variable color

    $chooselist selection clear $i
    $chooselist itemconfigure $i -foreground blue -background white
}

proc Choose::Unselect {i} {
    variable chooselist
    variable color

    $chooselist selection clear $i
    $chooselist itemconfigure $i -foreground $color(fg) -background $color(bg)
}

proc Choose::Enable {} {
    variable chooselist
    variable color

    $chooselist configure -foreground black
}

proc Choose::Disable {} {
    variable chooselist
    variable color

    $chooselist configure -foreground white
}
