.TH SIMPP 1L "Jan 6, 1994" "PSF-Toolkit" "LOCAL COMMANDS"
.UC 4
.SH NAME
simpp \- sim preprocessor, converts sorts and sets to enumerated sets in
TIL-specifications
.SH SYNOPSIS
.B simpp
[
.B \-dhinrsvV
] [
.B \-m\fInumber\fP
] [
.B \-S\fInames\fP
] ... [
.I file 
]
.SH DESCRIPTION
.B simpp
converts sorts and sets in a TIL-specification, taken from
.I file
or from standard input, to sets which consist only of an enumeration
of the elements, without any variables in them.
.PP
A sort or set that is converted gets an extra field in the free-format
(<enum>x, where x is the number of the enumerated set).
.PP
The resulting TIL-specification is written on standard output.
.PP
The names of the new sets are made by prepending "-set-" to the name of
the sort or the original set.
.PP
.B simpp
uses the function definitions for converting.  All function definitions
that have the sort that is to be converted as the return-type, are an
element of that sort.
If these functions that make up the sort do not have arguments, the sort
is converted to an enumerated set with these functions as elements.
If a function takes arguments then the sort can only be converted, if
the sorts of the arguments can be converted.  In that case, the set
contains elements build up from this function in which the arguments
have all possible values for their sorts.
.br
Sets which depend on enumerated sets, and sorts which can be converted to
enumerated sets, are converted to enumerated sets.
And further, all sets that depend on sets which can be converted, and
sorts which can be converted, are converted to enumerated sets.
.br
For the set operator '.' it is only necessary that one of the operands
can be converted to an enumerated set, and for the operator '\\' only
the left operand needs to be convertible.
.PP
If the
.B \-i
option is given, the initial algebra for the sorts that could not be
converted is generated.
This is done by computing segments for a sort.
All constant functions are put in the first segment for their
sort (return-type).
The following segments are computed by filling the arguments of the
non-constant functions with values from earlier segments. The result
is normalized and added to the new segment.
.br
This goes on until no elements are formed in the new segments, or
until the maximum number of elements of a sort is exceeded (see option
.BR \-m ).
.SH OPTIONS
.TP
.B \-d
A report of dependencies of sorts and set on each other is generated.
The empty line in the report seperates the sorts from the sets.
The field
.I convert
can have the following values.
.RS
.TP
.B no
No converting is done for this sort/set.
.TP
.B yes
This sort/set will be converted to an enumerated set.
.TP
.B depend
This sort/set will be converted, because another sort/set depends
on it, but there will be no enumerated set generated for this sort/set.
.TP
.B enum
This set is already an enumerated set.
.TP
.B done
This sort/set has already an enumerated set associated with it.
.RE
.TP
.B \-h
usage summary
.TP
.B \-i
Compute the Initial Algebra's for the sorts which could not be
converted.
.TP
.B \-n
The terms describing the elements of enumerated sets are normalized.
And also the arguments of the left-hand-side of process-definitions
are normalized.
.TP
.B \-r
A report of which sorts and sets are converted, is generated.
.TP
.B \-s
Only sorts and sets which are used for the placeholders of the sums and
merges in the TIL-specification, are converted.
.TP
.BI \-m number
Sets the maximum number of elements of the initial algebra to
.IR number .
The maximum defaults to 100.
.TP
.BI \-S names
Only sorts and sets mentioned in
.I names
are converted.
.I names
may be either a single name of a sort or set, or a comma-seperated
list (without spaces) of names. In case there are more sorts or sets
with the same name, this name must be prepended with the name of
the module it originates from and a dot (.), like this
.RS
    module.name
.RE
.TP
.B \-v
Displays the version-number of simpp.
.TP
.B \-V
Verbose mode.
.B simpp
shows what it is doing.
.SH AUTHOR
Bob Diertens, University of Amsterdam (bobd@fwi.uva.nl)
