#include <stdio.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "tiltype.h"
#include "eqm.h"
#include "main.h"
#include "item.h"
#include "fieldex.h"

eqm_t *eqm;

void init_normalize(mod)
struct module *mod;
{
    int i;

    eqm = create_eqm(mod->entries_table[FUN]);
    for (i = 1; i <= mod->entries_table[EQU]; i++)
	eqm = add_equation(eqm, mod->equ[i]);
}

static void normalize_set(st, atomset)
    struct s_term *st;
    int atomset;
{
    int i, j;
    struct ae_term *aet;
    struct ae_term *nf;

    if (st->fun != ENU) {
	for (i = 0; i < st->a; i++)
	    if (st->u_tag[i] == 1)
		normalize_set(st->arr[i].s_t, atomset);
    } else if (atomset)
	for (i = 0; i < st->a; i++) {
	    aet = st->arr[i].ae_t;
	    for (j = 0; j < aet->a; j++) {
		nf = term_reduce(eqm, &aet->
				 ae_list[j]);
		aet->ae_list[j] = *nf;
		PSF_FREE(nf);
	    }
	    for (j = 0; j < i; j ++) {
		if (!cmp_ae_term(st->arr[i].ae_t, st->arr[j].ae_t)) {
		    st->a --;
		    for (j = i; j < st->a; j ++)
			st->arr[j].ae_t = st->arr[j + 1].ae_t;
		    i --;
		    break;
		}
	    }
	}
    else
	for (i = 0; i < st->a; i++) {
	    aet = st->arr[i].ae_t;
	    st->arr[i].ae_t = term_reduce(eqm, aet);
	    for (j = 0; j < i; j ++) {
		if (!cmp_ae_term(st->arr[i].ae_t, st->arr[j].ae_t)) {
		    st->a --;
		    for (j = i; j < st->a; j ++)
			st->arr[j].ae_t = st->arr[j + 1].ae_t;
		    i --;
		    break;
		}
	    }
	    /*
	     * freeing this gives weird results ! because part of aet is shared
	     * somehow. free (aet);
	     */
	}
}

static void normalize_left_hand(aet)
    struct ae_term *aet;
{
    struct ae_term *nf;
    int j;

    for (j = 0; j < aet->a; j++) {
	nf = term_reduce(eqm, &aet->
			 ae_list[j]);
	aet->ae_list[j] = *nf;
	PSF_FREE(nf);
    }
}

void normalize(mod)
    struct module *mod;
{
    int i;

    if (Option_Verbose)
	fprintf(stderr, "Normalizing ...\n");

    for (i = 1; i <= mod->entries_table[SET]; i++)
	if (mod->set[i].u_tag == 1) {
	    if (Option_Verbose)
		fprintf(stderr, "    set %s\n", field_extract("n",
		    mod->set[i].ff, SET, i));
	    normalize_set(&mod-> set[i].construct.set_term,
		mod->set[i].ind.key == 0);
	}
    if (Option_Verbose)
	fprintf(stderr, "  definitions");
    for (i = 1; i <= mod->entries_table[DEF]; i++) {
	normalize_left_hand(&mod->def[i].ae_t);
    }
    if (Option_Verbose)
	fprintf(stderr, "\n");
}
