#include "psf_prototype.h"
#include "tiltype.h"

static int member_of_set PROTO_ARGS((struct module *, struct ae_term *, struct s_term *));

static struct indextype *get_sort(mod, ind)
    struct module *mod;
    struct indextype *ind;
{
    switch (ind->table) {
    case SOR:
	return (ind);
    case FUN:
	return (mod->fun[ind->key].return_list.indlist);
    case VAR:
	return (&mod->var[ind->key].ind);
    }

    return 0;			/* to shut up lint */
}

static int cmp_aet_sort(mod, aet1, aet2)
    struct module *mod;
    struct ae_term *aet1;
    struct ae_term *aet2;
{
    int i;
    struct indextype *sort1, *sort2;

    if ((aet1->ind.table != aet2->ind.table) || (aet1->ind.key
				    != aet2->ind.key) || (aet1->a != aet2->a))
	return (1);
    for (i = 0; i < aet1->a; i++) {

	if (!cmp_aet_sort(mod, &aet1->ae_list[i], &aet2->
			  ae_list[i]))
	    continue;
	if (aet2->ae_list[i].ind.table != VAR)
	    return (1);

	sort1 = get_sort(mod, &aet1->ae_list[i].ind);
	sort2 = get_sort(mod, &aet2->ae_list[i].ind);
	if (sort1->table == sort2->table &&
		sort1->key == sort2->key)
	    continue;
	if (sort2->table != SET)
	    return (1);
	if (!member_of_set(mod, &aet1->ae_list[i],
			   &mod->set[sort2->key].construct.set_term))
	    return (1);
    }
    return (0);
}

static int member_of_set(mod, aet, set)
    struct module *mod;
    struct ae_term *aet;
    struct s_term *set;
{
    int i;
    int member;
    keytype set_key;

    for (i = 0; i < set->a; i++) {
	if (set->u_tag[i])
	    member = member_of_set(mod, aet, set->arr[i].s_t);
	else if (set->arr[i].ae_t->ind.table == SOR)
	    member = 1;
	else if (set->arr[i].ae_t->ind.table == SET) {
	    set_key = set->arr[i].ae_t->ind.key;
	    member = member_of_set(mod, aet, &mod->
				   set[set_key].construct.set_term);
	} else
	    member = (!cmp_aet_sort(mod, aet, set->
				    arr[i].ae_t));
	switch (set->fun) {
	case UNI:
	    if (member)
		return (1);
	    break;
	case INT:
	    if (!member)
		return (0);
	    break;
	case DIF:
	    if (i) {
		if (member)
		    return (0);
		else
		    member = 1;
	    } else {
		if (!member)
		    return (0);
	    }
	    break;
	case ENU:
	    if (member)
		return (1);
	    break;
	}
    }
    return (member);
}

int member(mod, aet, st, i)
    struct module *mod;
    struct ae_term *aet;
    struct s_term *st;
    int i;
{
    keytype set_key;

    if (st->u_tag[i])
	return (member_of_set(mod, aet, st->arr[i].s_t));
    else if (st->arr[i].ae_t->ind.table == SOR)
	return (1);
    else if (st->arr[i].ae_t->ind.table == SET) {
	set_key = st->arr[i].ae_t->ind.key;
	return (member_of_set(mod, aet, &mod->
			      set[set_key].construct.set_term));
    } else
	return (!cmp_aet_sort(mod, aet, st->arr[i].ae_t));
}
