#include <assert.h>
#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "tiltype.h"
#include "fieldex.h"
#include "convert.h"
#include "item.h"
#include "main.h"
#include "makesets.h"
#include "initial.h"

static int **depend;

#define	NODEP	0
#define	DEP	1

int *conversion;

int *shoulddo;

static int n_of_sorts;
static int n_of_sets;
static int n_of_sorts_and_sets;

static int add_set;

static int *done;

static void make_depend_aet(indx, mod, aet)
    int indx;
    struct module *mod;
    struct ae_term *aet;
{
    int i;
    struct indextype *s_ind;

    if (aet->ind.table == VAR) {
	s_ind = &mod->var[aet->ind.key].ind;
	if (s_ind->table == SET)
	    depend[indx][n_of_sorts + s_ind->key] = DEP;
	else
	    depend[indx][s_ind->key] = DEP;
    }
    for (i = 0; i < aet->a; i++)
	make_depend_aet(indx, mod, &aet->ae_list[i]);
}

static void make_depend_st PROTO_ARGS((int, struct module *, struct s_term *));

static void make_depend_st_part(indx, mod, st, i)
    int indx;
    struct module *mod;
    struct s_term *st;
    int i;
{
    if (st->u_tag[i]) {
	make_depend_st(indx, mod, st->arr[i].s_t);
    } else {
	if (st->arr[i].ae_t->ind.table == SET)
	    depend[indx][n_of_sorts + st->arr[i].ae_t->ind.key] = DEP;
	else
	    depend[indx][st->arr[i].ae_t->ind.key] = DEP;
    }
}

static void make_depend_st(indx, mod, st)
    int indx;
    struct module *mod;
    struct s_term *st;
{
    int i;

    switch (st->fun) {
    case UNI:
	for (i = 0; i < st->a; i++) {
	    make_depend_st_part(indx, mod, st, i);
	}
	break;
    case INT:
	make_depend_st_part(indx, mod, st, 0);
	make_depend_st_part(indx, mod, st, 1);
	break;
    case DIF:
	make_depend_st_part(indx, mod, st, 0);
	make_depend_st_part(indx, mod, st, 1);
	break;
    case ENU:
	for (i = 0; i < st->a; i++)
	    make_depend_aet(indx, mod, st->arr[i].ae_t);
	break;
    }
}

static void collect_dep(x)
    int x;
{
    int i, j;

    for (i = 1; i <= n_of_sorts_and_sets; i++) {
	if (depend[x][i]) {
	    if (!done[i]) {
		done[i] = 1;	/* because of cycli */
		collect_dep(i);
	    }
	    for (j = 1; j <= n_of_sorts_and_sets; j++)
		if (depend[i][j])
		    depend[x][j] = DEP;
	}
    }
}

static void make_depend(mod)
    struct module *mod;
{
    int i, j;
    fun_tuple *fun;
    struct indextype *il;
    set_tuple *set;

    for (i = 1, fun = mod->fun; i <= mod->entries_table[FUN]; i++) {
	fun++;
	for (j = 0, il = fun->sor_indlist.indlist;
		j < fun->sor_indlist.a; j++, il++) {
	    depend[fun->return_list.indlist->key][(il->table
				    == SET ? n_of_sorts : 0) + il->key] = DEP;
	}
    }

    for (i = 1, set = mod->set; i <= n_of_sets; i++) {
	set++;
	if (set->ind.key != 0) {/* no atomset */
	    if (set->u_tag)
		make_depend_st(i + n_of_sorts, mod,
			       &set->construct.set_term);
	    else
		depend[n_of_sorts + i]
		    [(set->construct.sort.table == SET ?
		      n_of_sorts : 0) +
		     set->construct.sort.key] = DEP;
	}
    }

    done = PSF_NMALLOC(int, n_of_sorts_and_sets + 1);
    for (i = 1; i <= n_of_sorts_and_sets; i++)
	done[i] = 0;
    for (i = 1; i <= n_of_sorts_and_sets; i++)
	collect_dep(i);
}

struct ss_list {
    char *m_name;
    char *s_name;
    int table;
    int key;
    struct ss_list *next;
};
static struct ss_list *todo_list = NULL;

int set_do_sortset(str)
char *str;
{
    char *p, *s_end, *m_end;
    int endstr = 0;
    struct ss_list *h, *lastss;
    int l;

    p = str;
    while (! endstr) {
	h = PSF_MALLOC(struct ss_list);
	h->next = NULL;
	if (todo_list == NULL)
	    todo_list = h;
	else
	    lastss->next = h;
	lastss = h;

	s_end = strchr(p, ',');
	if (s_end == NULL) {
	    endstr = 1;
	    s_end = p + strlen(p);
	}
	if (s_end == p)
	    return(1);
	m_end = strchr(p, '.');
	if (m_end == NULL || m_end > s_end)
	    h->m_name = NULL;
	else {
	    if (m_end == p)
		return(1);
	    if (m_end + 1 == s_end)
		return(1);
	    l = (int) (m_end - p);
	    h->m_name = PSF_NMALLOC(char, l + 1);
	    (void) strncpy(h->m_name, p, l);
	    h->m_name[l] = '\0';

	    p = m_end + 1;
	}
	l = (int) (s_end - p);
	h->s_name = PSF_NMALLOC(char, l + 1);
	(void) strncpy(h->s_name, p, l);
	h->s_name[l] = '\0';

	p = s_end + 1;
    }
    return(0);
}

int check_do_sortset(mod)
struct module *mod;
{
    struct ss_list *h;
    int error = 0;
    int i;
    int nr;
    int found;
    int l;
    char *p, *f;
    int origin, o;

    h = todo_list;
    while (h != NULL) {
	if (h->m_name == NULL)
	    origin = 0;
	else {
	    nr = mod->entries_table[ADM];
	    found = 0;
	    for (i = 1; i <= nr; i ++) {
		if ((f = get_ff_field("m", mod->adm[i].ff)) == NULL)
		    continue;
		p = strchr(f, ' ') + 1;
		l = strcspn(p, " <");
		if (l != strlen(h->m_name))
		    continue;
		if (strncmp(h->m_name, p, l))
		    continue;
		sscanf(f, "%d", & origin);
		found = 1;
	    }
	    if (! found) {
		fprintf (stderr, "%s: the module \"%s\" in option -S can't be found in the TIL-file\n",
		    progname, h->m_name);
		error = 1;
		goto nexth;
	    }
	}
	found = 0;
	nr = mod->entries_table[SOR];
	for (i = 1; i <= nr; i ++) {
	    f = get_ff_field("n", mod->sor[i].ff);
	    l = strcspn(f, " <");
	    if (l != strlen(h->s_name))
		continue;
	    if (strncmp(h->s_name, f, l))
		continue;
	    if (origin != 0) {
		f = get_ff_field("o", mod->sor[i].ff);
		sscanf(f, "%d", &o);
		if (o != origin)
		    continue;
	    }
	    h->table = SOR;
	    h->key = i;
	    if (origin != 0)
		goto nexth;
	    if (found) {
		fprintf(stderr, "%s: the sort/set \"%s\" in option -S appears more than once in the TIL-file\n",
		    progname, h->s_name);
		    error = 1;
		    goto nexth;
	    }
	    found = 1;
	}
	nr = mod->entries_table[SET];
	for (i = 1; i <= nr; i ++) {
	    f = get_ff_field("n", mod->set[i].ff);
	    l = strcspn(f, " <");
	    if (l != strlen(h->s_name))
		continue;
	    if (strncmp(h->s_name, f, l))
		continue;
	    if (origin != 0) {
		f = get_ff_field("o", mod->set[i].ff);
		sscanf(f, "%d", &o);
		if (o != origin)
		    continue;
	    }
	    h->table = SET;
	    h->key = i;
	    if (origin != 0)
		goto nexth;
	    if (found) {
		fprintf(stderr, "%s: the sort/set \"%s\" in option -S appears more than once in the TIL-file\n",
		    progname, h->s_name);
		    error = 1;
		    goto nexth;
	    }
	    found = 1;
	}
	if (! found) {
	    fprintf(stderr, "%s: the sort/set \"", progname);
	    if (origin != 0)
		fprintf(stderr, "%s.", h->m_name);
	    fprintf(stderr, "%s\" in option -S can't be found in the TIL-file\n",
		h->s_name);
	    error = 1;
	}

nexth:
	h = h->next;
    }
    return(error);
}

void print_ss_list()
{
    struct ss_list *h;

    h = todo_list;

    while (h != NULL) {
	if (h->m_name != NULL)
	    fprintf(stderr, "%s.", h->m_name);
	fprintf(stderr, "%s %d.%d\n", h->s_name, h->table, h->key);

	h = h->next;
    }
}

static void make_shoulddo_pexpr(mod, pe)
    struct module *mod;
    struct process_expr *pe;
{
    int i;
    struct indextype *s_ind;

    switch (pe->fun) {
    case AET:
    case SKP:
    case DLK:
	break;
    case ALT:
    case SEQ:
    case PAR:
    case INTR:
    case DISR:
    case STAR:
    case SHARP:
	for (i = 0; i < pe->proc_expr.pe3.a; i++)
	    make_shoulddo_pexpr(mod, &pe->proc_expr.pe3.pe[i]);
	break;
    case SUM:
    case MRG:
	s_ind = &mod->var[pe->proc_expr.pe1.ind.key].ind;
	if (s_ind->table == SET)
	    shoulddo[n_of_sorts + s_ind->key] = DO;
	else
	    shoulddo[s_ind->key] = DO;
    case ENC:
    case HID:
	make_shoulddo_pexpr(mod, pe->proc_expr.pe1.pe);
	break;
    case IF:
	make_shoulddo_pexpr(mod, pe->proc_expr.pe4.pe);
	break;
    case PRIO:
	make_shoulddo_pexpr(mod, pe->proc_expr.pe5.pe);
	break;
    default:
	assert(0);		/* this shouldn't happen */
    }
}

static void make_shoulddo(mod)
    struct module *mod;
{
    int i, j;
    int NDEF;
    def_tuple *def;
    struct ss_list *h;

    for (i = 1; i <= n_of_sorts_and_sets; i++)
	if (Option_Summerge || todo_list != NULL)
	    shoulddo[i] = DO_NOT;
	else
	    shoulddo[i] = DO;
    for (i = 1; i <= n_of_sets; i++) {
	if (mod->set[i].ind.key == 0)	/* shouldn't do atom-sets */
	    shoulddo[i + n_of_sorts] = DO_NOT;
    }

    /* do sorts and sets in todo_list */
    h = todo_list;
    while (h != NULL) {
	if (h->table == SOR)
	    shoulddo[h->key] = DO;
	else
	    shoulddo[h->key + n_of_sorts] = DO;
	h = h->next;
    }

    /* do sorts and set for sum and merge */
    if (Option_Summerge) {
	NDEF = mod->entries_table[DEF];
	for (i = 1, def = mod->def; i <= NDEF; i++) {
	    def++;
	    make_shoulddo_pexpr(mod, &def->p_expr);
	}
    }

    /* do sorts and sets that are depended upon */
    if (Option_Summerge || todo_list != NULL) {
	for (i = 1; i <= n_of_sorts_and_sets; i++)
	    if (shoulddo[i])
		for (j = 1; j <= n_of_sorts_and_sets; j++)
		    if (depend[i][j])
			if (!shoulddo[j])
			    shoulddo[j] = DO_DEP;
    }
}

static int pure_fun(aet)
    struct ae_term *aet;
{
    int i;

    if (aet->ind.table == VAR)
	return (0);
    for (i = 0; i < aet->a; i++)
	if (!pure_fun(&aet->ae_list[i]))
	    return (0);
    return (1);
}

static void report_dep(mod)
    struct module *mod;
{
    int i, j;

    fprintf(stderr,
	    "index  name                       convert  dependencies\n"
	);
    for (i = 1; i <= n_of_sorts_and_sets; i++) {
	if (i == n_of_sorts + 1)
	    fprintf(stderr, "\n");
	if (i <= n_of_sorts)
	    fprintf(stderr, " %3d   %-25s ", i, field_extract("n",
		mod->sor[i].ff,SOR,i));
	else
	    fprintf(stderr, " %3d   %-25s ", i, field_extract("n",
		mod->set[i - n_of_sorts].ff,SET,i-n_of_sorts));
	if (conversion[i] == i)
	    fprintf(stderr, "  enum   ");
	else {
	    switch (shoulddo[i]) {
	    case DO_NOT:
		if (conversion[i] > CVT_NYET)
		    fprintf(stderr, "  done   ");
		else
		    fprintf(stderr, "  no     ");
		break;
	    case DO:
		fprintf(stderr, "  yes    ");
		break;
	    case DO_DEP:
		fprintf(stderr, " depend  ");
		break;
	    }
	}
	for (j = 1; j <= n_of_sorts_and_sets; j++)
	    if (depend[i][j])
		fprintf(stderr, " %2d", j);
	fprintf(stderr, "\n");
    }
}

static void enum_list(mod, lnr, setnr)
struct module *mod;
int lnr;
int setnr;
{
    struct s_term *st;
    int i;

    st = &mod->set[setnr].construct.set_term;
    for (i = 0; i < st->a; i ++)
	add_item(lnr, st->arr[i].ae_t);
}

static void make_enum_lists(mod)
struct module *mod;
{
    int i;
    char *p;
    int nr;

    for (i = 1; i <= n_of_sorts; i ++) {
	if ((p = get_ff_field("enum", mod->sor[i].ff)) != NULL) {
	    sscanf(p, "%d", &nr);
	    enum_list(mod, i, nr);
	    shoulddo[i] = DO_NOT;
	    conversion[i] = nr;
	}
    }
    for (i = 1; i <= n_of_sets; i ++) {
	if ((p = get_ff_field("enum", mod->set[i].ff)) != NULL) {
	    sscanf(p, "%d", &nr);
	    enum_list(mod, i + n_of_sorts, nr);
	    shoulddo[i + n_of_sorts] = DO_NOT;
	    conversion[n_of_sorts + i] = nr;
	}
    }
}
	    
static void mark_enum(mod)
    struct module *mod;
{
    int i, j;
    set_tuple *set;
    struct s_term *st;

    for (i = 1, set = mod->set; i <= n_of_sets; i++) {
	set++;
	if (set->ind.key == 0)
	    continue;
	if (set->u_tag == 0)
	    continue;
	st = &set->construct.set_term;
	if (st->fun != ENU)
	    continue;
	for (j = 0; j < st->a; j++) {
	    if (!pure_fun(st->arr[j].ae_t))
		break;
	}
	if (j == st->a) {
	    conversion[n_of_sorts + i] = n_of_sorts + i;
	    if (Option_Debug) {
		fprintf(stderr, "set %d is an enumeration\n", i);
	    }
	    enum_list(mod, i + n_of_sorts, i);
	}
    }
}

static void convert(mod)
    struct module *mod;
{
    int i, j;
    int something_done;
    int can_be_done;
    int extra;
    int round = 0;

    add_set = 0;

    extra = 0;
    for (i = 1; i <= n_of_sorts_and_sets; i++) {
	if (shoulddo[i] &&
	    (conversion[i] == CVT_NYET || conversion[i] == CVT_NPOS))
	    extra++;
    }
    if (extra == 0)
	return;
    mod->set = PSF_REALLOC(mod->set, set_tuple, mod->entries_table[SET] + 1 + extra);

    /* Should be split into sorts, sets, second round sets */
    /* And then right after sorts comes initial */
start:
    if (Option_Verbose)
	fprintf(stderr, "Converting ...\n");

    round ++;
    while (1) {
	something_done = 0;
	for (i = 1; i <= n_of_sorts_and_sets; i++) {
	    if (shoulddo[i] == DO_NOT)
		continue;
	    if (conversion[i] != CVT_NYET)
		continue;
	    can_be_done = 1;
	    for (j = 1; j <= n_of_sorts_and_sets; j++) {
		if (depend[i][j]) {
		    if (conversion[j] <= CVT_NYET) {
			can_be_done = 0;
			break;
		    }
		}
	    }
	    if (!can_be_done)
		continue;
	    if (i > n_of_sorts) {
		if (Option_Verbose)
		    fprintf(stderr, "    set %s  ", field_extract("n",
			mod->set[i - n_of_sorts].ff, SET, i - n_of_sorts));
		convert_set(mod, i - n_of_sorts);
		if (Option_Verbose)
		    fprintf(stderr, "\n");
		add_set ++;
		conversion[i] = add_set + n_of_sorts_and_sets;
	    } else {
		if (Option_Verbose)
		    fprintf(stderr, "    sort %s  ", field_extract("n",
			mod->sor[i ].ff, SOR, i));
		convert_sort(mod, i);
		if (Option_Verbose)
		    fprintf(stderr, "\n");
		add_set ++;
		conversion[i] = add_set + n_of_sorts_and_sets;
	    }
	    something_done = 1;
	}
	if (!something_done)
	    break;
    }

    if (Option_Verbose)
	fprintf(stderr, "  second round for sets ...\n");
    while (1) {			/* second chance for sets */
	something_done = 0;
	for (i = n_of_sorts + 1; i <= n_of_sorts_and_sets; i++) {
	    if (shoulddo[i] == DO_NOT || conversion[i] != CVT_NYET)
		continue;
	    if (can_convert_set(mod, i - n_of_sorts)) {
		if (Option_Verbose)
		    fprintf(stderr, "    set %s  ", field_extract("n",
			mod->set[i - n_of_sorts].ff, SET, i - n_of_sorts));
		convert_set(mod, i - n_of_sorts);
		if (Option_Verbose)
		    fprintf(stderr, "\n");
		add_set ++;
		conversion[i] = add_set + n_of_sorts_and_sets;
		something_done = 1;
	    }
	}
	if (!something_done)
	    break;
    }

    if (round == 2)
	return;

    if (Option_Initial) {
	initial(mod);
	something_done = 0;
	for (i = 1; i <= n_of_sorts; i ++) {
	    if (shoulddo[i] == DO_NOT)
		continue;
	    if (conversion[i] != CVT_NPOS)
		continue;
	    if (get_nr_items(i)) {
		add_set ++;
		conversion[i] = add_set + n_of_sorts_and_sets;
		something_done = 1;
	    }
	}
    }

    if (something_done)
	goto start;
}

static void add_sets(mod)
struct module *mod;
{
    int i, j;
    set_tuple *set;
    struct s_term *st;
    item_t *h;
    char *newff, *n;

    for (i = 1; i <= n_of_sorts_and_sets; i ++) {
	if (conversion[i] <= n_of_sorts_and_sets)
	    continue;
	if (shoulddo[i] == DO_DEP)
	    continue;
	mod->entries_table[SET] ++;
	set = &mod->set[mod->entries_table[SET]];
	if (i <= n_of_sorts) {
	    set->ind.table = SOR;
	    set->ind.key = i;
	} else {
	    set->ind = mod->set[i - n_of_sorts].ind;
	}
	set->u_tag = 1;
	st = &set->construct.set_term;
	st->fun = ENU;
	st->a = get_nr_items(i);
	if (st->a == 0) {
	    st->u_tag = NULL;
	    st->arr = NULL;
	} else {
	    st->u_tag = PSF_NMALLOC(int, st->a);
	    st->arr = PSF_NMALLOC(union terms, st->a);
	    h = get_item_list(i);
	    for (j = 0; j < st->a; j ++) {
		st->u_tag[j] = 0;
		st->arr[j].ae_t = h->aet;
		h = h->next;
	    }
	}

#ifdef NEWFF
    /*
     * This code is not tested !!!!
     * Because writetil doesn't know about the new ff.
     */
	{
	freeformat ff;

	if (i <= n_of_sorts)
	    n = field_extract("n", mod->sor[i].ff, SOR, i);
	else
	    n = field_extract("n", mod->set[i - n_of_sorts].ff, SOR,
		i - n_of_sorts);
	
	ff = PSF_MALLOC(struct new_freeformat);
	set->ff = ff;
	ff->tag = PSF_NMALLOC(char, strlen("n") + 1);
	sprintf(ff->tag, "n");
	ff->info = PSF_NMALLOC(char, strlen(n) + 5);
	sprintf(ff->info, "set-%s", n);
	ff->next = PSF_MALLOC(struct new_freeformat);
	ff = ff->next;
	ff->tag = PSF_NMALLOC(char, strlen("o") + 1);
	sprintf(ff->tag, "o");
	ff->info = PSF_NMALLOC(char, 2);
	sprintf(ff->info, "0");
	ff->next = NULL;

	if (i <= n_of_sorts)
	    ff = mod->sor[i].ff;
	else
	    ff = mod->set[i - n_of_sorts].ff;
	while (ff->next != NULL)
	    ff = ff->next;
	ff->next = PSF_MALLOC(struct new_freeformat);
	ff = ff->next;
	ff->tag = PSF_NMALLOC(char, strlen("enum") + 1);
	sprintf(ff->tag, "enum");
	ff->info = PSF_NMALLOC(char, 5); /* should be enough */
	sprintf(ff->info, "%d", mod->entries_table[SET]);
	ff->next = NULL;
	}
#else /* NEWFF */
	if (i <= n_of_sorts)
	    n = field_extract("n", mod->sor[i].ff, SOR, i);
	else
	    n = field_extract("n", mod->set[i - n_of_sorts].ff, SOR,
		i - n_of_sorts);
	set->ff = PSF_NMALLOC(char, strlen(n) + 13);
	sprintf(set->ff, "<n>set-%s <o>0", n);

	if (i <= n_of_sorts)
	    n = mod->sor[i].ff;
	else
	    n = mod->set[i - n_of_sorts].ff;
	newff = PSF_NMALLOC(char, strlen(n) + 12);
	sprintf(newff, "%s <enum>%d", n, mod->entries_table[SET]);
	if (i <= n_of_sorts)
	    mod->sor[i].ff = newff;
	else
	    mod->set[i - n_of_sorts].ff = newff;
#endif /* NEWFF */
    }
}
	
void make_sets(mod)
    struct module *mod;
{
    int i, j;

    n_of_sorts = mod->entries_table[SOR];
    n_of_sets = mod->entries_table[SET];
    n_of_sorts_and_sets = n_of_sorts + n_of_sets;

    init_item(n_of_sorts_and_sets);

    depend = PSF_NMALLOC(int *, n_of_sorts_and_sets + 1);
    for (i = 1; i <= n_of_sorts_and_sets; i++) {
	depend[i] = PSF_NMALLOC(int, n_of_sorts_and_sets + 1);
	for (j = 1; j <= n_of_sorts_and_sets; j++)
	    depend[i][j] = NODEP;
    }
    shoulddo = PSF_NMALLOC(int, n_of_sorts_and_sets + 1);
    for (i = 1; i <= n_of_sorts_and_sets; i++)
	shoulddo[i] = DO_NOT;

    make_depend(mod);

    make_shoulddo(mod);

    conversion = PSF_NMALLOC(int, n_of_sorts_and_sets + 1);
    for (i = 1; i <= n_of_sorts_and_sets; i++) {
	conversion[i] = CVT_NYET;
	if (depend[i][i])
	    conversion[i] = CVT_NPOS;
    }

    make_enum_lists(mod);

    mark_enum(mod);

    if (Option_Depreport)
	report_dep(mod);

    convert(mod);

    add_sets(mod);
}

void report(mod)
    struct module *mod;
{
    int i;
    int announced;
    int snr;

    announced = 0;
    for (i = 1; i <= n_of_sorts; i++) {
	if (shoulddo[i] == DO && conversion[i] > CVT_NYET) {
	    if (!announced) {
		fprintf(stderr,
			"Sorts converted to enumerated sets:\n"
		    );
		announced = 1;
	    }
	    sscanf(field_extract("enum", mod->sor[i].ff, SOR, i), "%d", &snr);
	    fprintf(stderr, "\t%s (%d)\n", field_extract("n",
		mod->sor[i].ff,SOR,i),
		mod->set[snr].construct.set_term.a);
	}
    }

    announced = 0;
    for (i = 1; i <= n_of_sorts; i++) {
	if (shoulddo[i] == DO && conversion[i] <= CVT_NYET) {
	    if (!announced) {
		fprintf(stderr, "Could not convert:\n");
		announced = 1;
	    }
	    fprintf(stderr, "\t%s\n", field_extract("n",
		mod->sor[i].ff,SOR,i));
	}
    }

    announced = 0;
    for (i = 1; i <= n_of_sets; i++) {
	if (shoulddo[i + n_of_sorts] == DO &&
		(conversion[i + n_of_sorts] > CVT_NYET) &&
		(conversion[i + n_of_sorts] != i +
		 n_of_sorts)) {
	    if (!announced) {
		fprintf(stderr,
			"Sets converted to enumerated sets:\n");
		announced = 1;
	    }
	    fprintf(stderr, "\t%s (%d)\n",
		field_extract("n", mod->set[i].ff, SET, i),
		mod->set[conversion[i + n_of_sorts] -
		    n_of_sorts].construct.set_term.a);
	}
    }

    announced = 0;
    for (i = 1; i <= n_of_sets; i++) {
	if (shoulddo[i + n_of_sorts] == DO &&
		conversion[i + n_of_sorts] <= CVT_NYET) {
	    if (!announced) {
		fprintf(stderr, "Could not convert:\n");
		announced = 1;
	    }
	    fprintf(stderr, "\t%s\n", field_extract("n", mod->set[i].ff, SET,
		i));
	}
    }
}
