#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "tiltype.h"
#include "eqm.h"
#include "readtil.h"
#include "writetil.h"
#include "makesets.h"
#include "normalize.h"
#include "version.h"
#include "main.h"

#define USAGE "usage: simpp [-dhinrsvV] [-m number] [-S names] ... [file]\n"

static int Option_Normalize = 0;
static int Option_Report = 0;
int Option_Summerge = 0;
int Option_Depreport = 0;
int Option_Verbose = 0;
int Option_Initial = 0;
int Max_Elements = 100;
int Option_Debug = 0;

extern int getopt PROTO_ARGS((int, char * PROTO_CONST *,  PROTO_CONST char *));
extern int optind;
extern char *optarg;

char *progname;
char *filename;

static void sort_to_set(s, fp)
    char *s;
    FILE *fp;
{
    struct module the_module;
    struct module *mod = &the_module;

    mod->name = psf_basename(s);
    filename = s;
    if (read_module(mod, fp)) {
	fprintf(stderr, "error in input\n");
	exit(1);
    }

    if (check_do_sortset(mod))
	exit(1);

    init_normalize(mod);

    make_sets(mod);

    if (Option_Normalize)
	normalize(mod);

    if (Option_Report)
	report(mod);

    write_module(mod, stdout);
}

extern int optind;
extern char *optarg;

int main(argc, argv)
    int argc;
    char *argv[];
{
    FILE *input;
    int opt;

    progname = psf_basename(argv[0]);
    while ((opt = getopt(argc, argv, "dhim:nrsvS:VD")) != -1) {
	switch (opt) {
	case 'd':
	    Option_Depreport = 1;
	    break;
	case 'i':
	    Option_Initial = 1;
	    break;
	case 'm':
	    if (sscanf(optarg, "%d", & Max_Elements) != 1) {
		fprintf(stderr, "%s: error in argument of option -m\n",
		    progname);
		exit(1);
	    }
	    break;
	case 'n':
	    Option_Normalize = 1;
	    break;
	case 'r':
	    Option_Report = 1;
	    break;
	case 's':
	    Option_Summerge = 1;
	    break;
	case 'v':
	    fprintf(stderr, "simpp version %s, last compiled %s\n",
		    VERSION, __DATE__);
	    exit(0);
	case 'S':
	    if(set_do_sortset(optarg)) {
		fprintf(stderr, "%s: error in option -S%s\n", progname,
		    optarg);
		exit(1);
	    }
	    break;
	case 'V':
	    Option_Verbose = 1;
	    break;
	case 'D':
	    Option_Debug = 1;
	    break;
	case 'h':
	case '?':
	    fprintf(stderr, USAGE);
	    exit(1);
	}
    }
    argc -= optind - 1;
    argv += optind - 1;

    if (argc > 2) {
	fprintf(stderr, USAGE);
	exit(1);
    }
    write_til_init();
    if (argc == 2) {
	if ((input = fopen(argv[1], "r")) == NULL) {
	    fprintf(stderr, "%s: can't read ", progname);
	    perror(argv[1]);
	    exit(1);
	}
	sort_to_set(argv[1], input);
    } else
	sort_to_set("stdin", stdin);

    return 0;
}
