#include <stdio.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "tiltype.h"
#include "item.h"
#include "main.h"

static item_t **lists;
static item_t **plist;
static int nr_lists;
static int *nr_items;

static item_t **segment;
static item_t **end_segment;

void init_item(nr)
int nr;
{
    int i;

    nr_lists = nr;
    lists = PSF_NMALLOC(item_t *, nr + 1);
    plist = PSF_NMALLOC(item_t *, nr + 1);
    nr_items = PSF_NMALLOC(int, nr + 1);
    segment = PSF_NMALLOC(item_t *, nr + 1);
    end_segment = PSF_NMALLOC(item_t *, nr + 1);
    for (i = 0; i <= nr; i ++) {
	lists[i] = NULL;
	plist[i] = NULL;
	nr_items[i] = 0;
	segment[i] = NULL;
	end_segment[i] = NULL;
    }
}

int cmp_ae_term(aet1, aet2)
struct ae_term *aet1;
struct ae_term *aet2;
{
    int i;
    int res;

    if (aet1->ind.table != aet2->ind.table)
	return (aet1->ind.table - aet2->ind.table);
    if (aet1->ind.key != aet2->ind.key)
	return (aet1->ind.key - aet2->ind.key);
    if (aet1->a != aet2->a)
	return (aet1->a - aet2->a);
    for (i = 0; i < aet1->a; i++) {
	res = cmp_ae_term(&aet1->ae_list[i], &aet2->ae_list[i]);
	if (res)
	    return (res);
    }
    return (0);
}

int add_item(lnr, aet)
int lnr;
struct ae_term *aet;
{
    item_t *h;

    h = lists[lnr];
    while (h != NULL) {
	if (!cmp_ae_term(h->aet, aet)) {
	    return(0);		    /* no doubles in the list */
	}
	h = h->next;
    }
    h = PSF_MALLOC(item_t);
    h->aet = aet;
    h->next = NULL;
    if (plist[lnr] == NULL)
	lists[lnr] = h;
    else
	plist[lnr]->next = h;
    plist[lnr] = h;
    nr_items[lnr] ++;

    if (Option_Verbose)
	fprintf(stderr, "%5d\b\b\b\b\b", nr_items[lnr]);

    return(1);
}

void delete_item(lnr, item)
int lnr;
item_t *item;
{
    item_t *h;

    h = lists[lnr];
    if (h == item) {
	lists[lnr] = h->next;
	if (h == segment[lnr])
	    segment[lnr] = h->next;
	if (h == plist[lnr])
	    plist[lnr] = h->next;
	PSF_FREE(h);
    } else {
	while (h->next != item)
	    h = h->next;
	h->next = item->next;
	if (segment[lnr] == item)
	    segment[lnr] = h;
	if (plist[lnr] == item)
	    plist[lnr] = h;
	PSF_FREE(item);
    }
    nr_items[lnr] --;

    if (Option_Verbose)
	fprintf(stderr, "%5d\b\b\b\b\b", nr_items[lnr]);
}

void init_segments()
{
    int i;

    for (i = 0; i <= nr_lists; i ++) {
	segment[i] = lists[i];
	end_segment[i] = plist[i];
    }
}

void shift_segments()
{
    int i;

    for (i = 0; i <= nr_lists; i ++) {
	segment[i] = end_segment[i];
	if (segment[i] != NULL)
	    segment[i] = segment[i]->next;
	else
	    segment[i] = lists[i];
	end_segment[i] = plist[i];
    }
}

item_t *get_item_list(nr)
int nr;
{
    return(lists[nr]);
}

item_t *get_item_segment(nr)
int nr;
{
    return(segment[nr]);
}

item_t *get_end_list(nr)
int nr;
{
    return(plist[nr]);
}

int get_nr_items(nr)
int nr;
{
    return(nr_items[nr]);
}

void get_segments(b, e)
item_t ***b;
item_t ***e;
{
    *b = segment;
    *e = end_segment;
}
