#include <stdio.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "tiltype.h"
#include "eqm.h"
#include "main.h"
#include "normalize.h"
#include "makesets.h"
#include "item.h"
#include "fieldex.h"

/*
struct vars {
    int a;
    keytype *var;
    int maxa;
};
static struct vars *key_vars;

static void add_key_var(kv, key)
struct vars *kv;
keytype key;
{
    int i;

    for (i = 0; i < kv->a; i ++)
	if (kv->var[i] == key)
	    return;
    if (kv->a == kv->maxa) {
	if (kv->maxa ++ == 0)
	    kv->var = PSF_MALLOC(keytype);
	else
	    kv->var = PSF_REALLOC(kv->var, keytype, kv->maxa);
    }
    kv->var[kv->a ++] = key;
}

static void gen_key_var(kv, aet)
struct vars *kv;
struct ae_term * aet;
{
    int i;

    if (aet->ind.table == VAR)
	add_key_var(kv, aet->ind.key);
    else
	for (i = 0; i < aet->a; i ++)
	    gen_key_var(kv, &aet->ae_list[i]);
}

static void make_key_vars(mod)
struct module * mod;
{
    int i;
    int nr;
    struct vars *kv;

    nr = mod->entries_table[EQU];
    key_vars = PSF_NMALLOC(struct vars, nr + 1);
    for (i = 1, kv = key_vars + 1; i <= nr; i ++, kv ++) {
	kv->a = 0;
	kv->maxa = 0;
	gen_key_var(kv, &mod->equ[i].aet1);
    }
}
*/

static int seg_nr = 0;

static void add_constants(mod)
struct module *mod;
{
    int i;
    int nr;
    fun_tuple *fn;
    struct ae_term aet, *traet;
    keytype t;

    nr = mod->entries_table[FUN];
    fn = mod->fun + 1;
    for (i = 1; i <= nr; i ++, fn ++) {
	t = fn->return_list.indlist->key;
	if (shoulddo[t] == DO_NOT)
	    continue;
	if (conversion[t] != CVT_NPOS)
	    continue;
	if (fn->sor_indlist.a != 0)
	    continue;
	if (Option_Verbose)
	    fprintf (stderr, "    %-16s segment %2d  ", field_extract("n",
		mod->sor[t].ff, SOR, t), seg_nr);
	aet.t = TERM;
	aet.ind.table = FUN;
	aet.ind.key = i;
	aet.a = 0;
	if (!add_item(t, traet = term_reduce(eqm, &aet)))
	    ae_term_free(traet);

	if (Option_Verbose)
	    fprintf(stderr, "\n");
    }
}

void initial(mod)
struct module *mod;
{
    int i, j;
    item_t **bseg, **eseg;
    int nre, nrs, nrf;
    fun_tuple *fun;
    int active;
    item_t ** list;
    item_t *** ll;
    struct ae_term aet, *traet;
    struct indextype ind;
    struct indextype *il;
    int si, a;
    int segind;

    if (Option_Verbose)
	fprintf(stderr, "Computing Initial Algebra's ...\n");

    /* add constant functions */
    add_constants(mod);
    seg_nr ++;

    /* initialize segments */
    init_segments();
    get_segments(&bseg, &eseg);

    nre = mod->entries_table[EQU];
    nrs = mod->entries_table[SOR];
    nrf = mod->entries_table[FUN];
    
    active = 1;
    ind.table = VAR;

    ll = PSF_NMALLOC(item_t **, nrf + 1);
    for (i = 1, fun = mod->fun + 1; i <= nrf; i ++, fun ++)
	ll[i] = PSF_NMALLOC(item_t *, fun->sor_indlist.a);
    while (active) {
	for (i = 1, fun = mod->fun + 1; i <= nrf; i ++, fun ++) {
	    si = fun->return_list.indlist->key;
	    if (shoulddo[si] == DO_NOT)
		continue;
	    if (conversion[si] != CVT_NPOS)
		continue;
	    a = fun->sor_indlist.a;
	    if (a == 0)
		continue;
	    if (get_nr_items(si) >= Max_Elements)
		continue;
	    list = ll[i];
	    il = fun->sor_indlist.indlist;
	    segind = a - 1;
	    for (j = a - 1; j >= 0; j--) {
		if (eseg[il[j].key] == NULL) /* no elems, so no permutation */
		    goto endperm;
		if (j == segind) {
		    list[j] = get_item_segment(il[j].key);
		    if (list[j] == NULL) {
			list[j] = get_item_list(il[j].key);
			segind --;
			if (segind == 0)
			    goto endperm;
		    }
		} else
		    list[j] = get_item_list(il[j].key);
	    }
	    if (Option_Verbose) {
		fprintf(stderr, "    %-16s segment %2d  ", field_extract("n",
		    mod->sor[si].ff, SOR, si), seg_nr);
	    }

	    while (list[0] != eseg[il[0].key]->next) {
		aet.t = TERM;
		aet.ind.table = FUN;
		aet.ind.key = i;
		aet.a = a;
		aet.ae_list = PSF_NMALLOC(struct ae_term, a);
		for (j = 0; j < a; j++) {
		    aet.ae_list[j] = *list[j]->aet;
		}
		if (!add_item(si, traet = term_reduce(eqm, &aet)))
		    ae_term_free(traet);
		else
		    if (get_nr_items(si) >= Max_Elements)
			goto enddloop;
		PSF_FREE(aet.ae_list);
		j = a - 1;
		list[j] = list[j]->next;
		if (j == segind - 1) {
		    if (list[j] == get_item_segment(il[j].key)) {
			segind --;
		    }
		}
		while (list[j] == eseg[il[j].key]->next && j >= 0) {
		    list[j] = get_item_list(il[j].key);
		    if (-- j < 0)
			goto enddloop;
		    list[j] = list[j]->next;
		    if (j == segind - 1) {
			if (list[j] == get_item_segment(il[j].key)) {
			    segind --;
			}
		    }
		}
		if (j < segind)
		    list[segind] = get_item_segment(il[segind].key);
/*
		while (list[j] == eseg[il[j].key]->next && j >= 0) {
		    if (j == segind) {
			do {
			    list[segind] = get_item_list(il[segind].key);
			    segind ++;
			    if (segind == a) {
				if (j == segind - 1)
				    break;
				segind --;
				break;
			    }
			    list[segind] = get_item_segment(il[segind].key);
			} while (list[segind] == eseg[il[segind].key]->next);
			if (j < segind)
			    continue;
		    } else
			list[j] = get_item_list(il[j].key);
		    j --;
		    if (j < 0)
			goto enddloop;
		    list[j] = list[j]->next;
		}
*/
	    }

enddloop:
	    if (Option_Verbose)
		fprintf(stderr, "\n");
endperm:
	    ;
	}

	shift_segments();
	get_segments(&bseg, &eseg);
	seg_nr ++;

	/* test for activity */
	active = 0;
	for (i = 1; i <= nrs; i ++) {
	    if (bseg[i] != NULL) {
		active = 1;
		break;
	    }
	}
    }
}
