#include <stdio.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "tiltype.h"
#include "item.h"
#include "makesets.h"
#include "makesetsutil.h"
#include "main.h"

#define	sortsetnr(X)	((conversion[X] > 0) ? conversion[X]-NSOR : 0)
#define	setsetnr(X)	((conversion[NSOR+X] > 0) ? conversion[NSOR+X]-NSOR : 0)

static struct module *mod;
static int NSOR;

struct vars {
    int a;
    keytype *var;
    int maxa;
};
static struct vars var_list = {0, NULL, 0};

static int add_var_list(key)
    keytype key;
{
    int i;

    for (i = 0; i < var_list.a; i++)
	if (var_list.var[i] == key)
	    return (0);
    if (var_list.a == var_list.maxa) {
	if (var_list.maxa++ == 0)
	    var_list.var = PSF_MALLOC(keytype);
	else
	    var_list.var = PSF_REALLOC(var_list.var, keytype, var_list.maxa);
    }
    var_list.var[var_list.a++] = key;
    return (1);
}

static void free_var_list()
{
    var_list.a = 0;
}

static int get_nr_key(key)
    keytype key;
{
    int i;

    for (i = 0; i < var_list.a; i++)
	if (var_list.var[i] == key)
	    return (i);
    return(-1); /* should not happen */
}

static int check_aet(aet)
    struct ae_term *aet;
{
    int i;
    struct indextype *s_ind;

    if (aet->ind.table == VAR) {
	s_ind = &mod->var[aet->ind.key].ind;
	if (s_ind->table == SET)
	    return (setsetnr(s_ind->key));
	else
	    return (sortsetnr(s_ind->key));
    }
    for (i = 0; i < aet->a; i++)
	if (!check_aet(&aet->ae_list[i]))
	    return (0);
    return (1);
}

static int check_st PROTO_ARGS((struct s_term *));

static int check_st_part(st, i)
    struct s_term *st;
    int i;
{
    if (st->u_tag[i]) {
	if (!check_st(st->arr[i].s_t))
	    return (0);
    } else {
	if (st->arr[i].ae_t->ind.table == SET) {
	    if (!setsetnr(st->arr[i].ae_t->
			  ind.key))
		return (0);
	} else if (!sortsetnr(st->arr[i].ae_t->
			      ind.key))
	    return (0);
    }
    return(1);
}

static int check_st(st)
    struct s_term *st;
{
    int i;

    switch (st->fun) {
    case UNI:
	for (i = 0; i < st->a; i++) {
	    if (check_st_part(st, i) == 0)
		return (0);
	}
	return (1);
    case INT:
	if (!check_st_part(st, 0) && !check_st_part(st, 1))
	    return (0);
	else
	    return (1);
    case DIF:
	if (!check_st_part(st, 0))
	    return (0);
	else
	    return (1);
    case ENU:
	for (i = 0; i < st->a; i++)
	    if (!check_aet(st->arr[i].ae_t))
		return (0);
	return (1);
    }
    return(-1); /* should not happen */
}

static int check_set(set)
    set_tuple *set;
{
    if (set->ind.key == 0)
	return (0);
    if (set->u_tag) {
	return (check_st(&set->construct.set_term));
    } else {
	if (set->construct.sort.table == SET)
	    return (check_set(&mod->set[set->
					construct.sort.key]));
	else if (sortsetnr(set->construct.sort.key))
	    return (1);
	else
	    return (0);
    }
}

int can_convert_set(tilmod, i)
    struct module *tilmod;
    int i;
{
    mod = tilmod;
    return (check_set(&mod->set[i]));
}

static void make_fun_term(fun, fun_nr, sort_nr)
    fun_tuple *fun;
    int fun_nr;
    int sort_nr;
{
    struct ae_term *aet;
    item_t ** list;
    int j;

    if (fun->sor_indlist.a == 0) {
	aet = PSF_MALLOC(struct ae_term);
	aet->t = TERM;
	aet->ind.table = FUN;
	aet->ind.key = fun_nr;
	aet->a = 0;
	add_item(sort_nr, aet);
	return;
    }
    list = PSF_NMALLOC(item_t *, fun->sor_indlist.a);
    for (j = 0; j < fun->sor_indlist.a; j++) {
	list[j] = get_item_list(fun->sor_indlist.indlist[j].key);
    }
    while (list[0] != NULL) {
	aet = PSF_MALLOC(struct ae_term);
	aet->t = TERM;
	aet->ind.table = FUN;
	aet->ind.key = fun_nr;
	aet->a = fun->sor_indlist.a;
	aet->ae_list = PSF_NMALLOC(struct ae_term, fun->sor_indlist.a);
	for (j = 0; j < fun->sor_indlist.a; j++) {
	    aet->ae_list[j] = *list[j]->aet;
	}
	add_item(sort_nr, aet);
	j = fun->sor_indlist.a - 1;
	list[j] = list[j]->next;
	while (list[j] == NULL && j > 0) {
	    list[j] = get_item_list(fun->sor_indlist.indlist[j].key);
	    j --;
	    list[j] = list[j]->next;
	}
    }
    PSF_FREE(list);
}

static struct ae_term *set_term_copy_aet(aet, list)
struct ae_term *aet;
item_t **list;
{
    int nr;
    struct ae_term *caet;
    int i;

    if (aet->ind.table == VAR) {
	nr = get_nr_key(aet->ind.key);
	return(list[nr]->aet);
    }
    caet = PSF_MALLOC(struct ae_term);
    caet->t = TERM;
    caet->ind = aet->ind;
    caet->a = aet->a;
    caet->ae_list = PSF_NMALLOC(struct ae_term, aet->a);
    for (i = 0; i < caet->a; i++)
	caet->ae_list[i] = *set_term_copy_aet(&aet->ae_list[i], list);
    return (caet);
}

static void gen_var_list(aet)
    struct ae_term *aet;
{
    int i;

    if (aet->ind.table == VAR)
	add_var_list(aet->ind.key);
    else {
	for (i = 0; i < aet->a; i++)
	    gen_var_list(&aet->ae_list[i]);
    }
}

static void make_set_term_aet(aet, nr_set)
struct ae_term *aet;
int nr_set;
{
    item_t **list;
    int i, j;
    struct indextype *s_ind;

    gen_var_list(aet);
    if (var_list.a == 0) {
	add_item(nr_set + NSOR, aet);
	free_var_list();
	return;
    }
    list = PSF_NMALLOC(item_t *, var_list.a);
    for (i = 0; i < var_list.a; i++) {
	s_ind = &mod->var[var_list.var[i]].ind;
	if (s_ind->table == SET)
	    list[i] = get_item_list(s_ind->key + NSOR);
	else
	    list[i] = get_item_list(s_ind->key);
    }
    while (list[0] != NULL) {
	add_item(nr_set + NSOR, set_term_copy_aet(aet, list));
	j = var_list.a - 1;
	list[j] = list[j]->next;
	while (list[j] == NULL && j > 0) {
	    s_ind = &mod->var[var_list.var[j]].ind;
	    if (s_ind->table == SET)
		list[j] = get_item_list(s_ind->key + NSOR);
	    else
		list[j] = get_item_list(s_ind->key);
	    j --;
	    list[j] = list[j]->next;
	}
    }
    PSF_FREE(list);
    free_var_list();
}

static void add_setlist_to_list(key, nr_set)
int key;
int nr_set;
{
    item_t *h;

    h = get_item_list(key);
    while (h != NULL) {
	add_item(nr_set + NSOR, h->aet);
	h = h->next;
    }
}

static void make_set_term();
static void make_set_term_st();

static void make_set_term_st_part(st, nr_set, i)
struct s_term *st;
int nr_set;
int i;
{
    if (st->u_tag[i])
	make_set_term_st(st->arr[i].s_t, nr_set);
    else {
	if (st->arr[i].ae_t->ind.table == SET) {
	    if (conversion[st->arr[i].ae_t->ind.key + NSOR] >
		st->arr[i].ae_t->ind.key + NSOR)
		add_setlist_to_list(st->arr[i].ae_t->ind.key + NSOR, nr_set);
	    else
		make_set_term(&mod->set[st->arr[i].ae_t->ind.key], nr_set);
	} else {
	    add_setlist_to_list(st->arr[i].ae_t->ind.key, nr_set);
	}
    }
}

static void make_set_term_st(st, nr_set)
struct s_term *st;
int nr_set;
{
    int i;
    item_t *start;

    switch (st->fun) {
    case UNI:
	make_set_term_st_part(st, nr_set, 0);
	start = get_end_list(nr_set+NSOR);
	make_set_term_st_part(st, nr_set, 1);
	make_dif(mod, start, st, 0, nr_set);
	/*
	 * THere will be no doubles put in the list, so start and make_dif
	 * are not necessary
	 */
	break;
    case INT:
	start = get_end_list(nr_set+NSOR);
	if (check_st_part(st, 0))
	    i = 0;
	else
	    i = 1;
	make_set_term_st_part(st, nr_set, i);
	make_int(mod, start, st, 1 - i, nr_set);
	break;
    case DIF:
	start = get_end_list(nr_set+NSOR);
	make_set_term_st_part(st, nr_set, 0);
	make_dif(mod, start, st, 1, nr_set);
	break;
    case ENU:
	for (i = 0; i < st->a; i++) {
	    make_set_term_aet(st->arr[i].ae_t, nr_set);
	}
	break;
    }
}

static void make_set_term(set, nr_set)
set_tuple *set;
int nr_set;
{
    if (set->u_tag) {
	make_set_term_st(&set->construct.set_term, nr_set);
    } else {
	if (set->construct.sort.table == SET) {
	    if (conversion[set->construct.sort.key + NSOR] >
		set->construct.sort.key + NSOR)
		add_setlist_to_list(set->construct.sort.key + NSOR, nr_set);
	    else
		make_set_term(&mod->set[set->construct.sort.key], nr_set);
	} else {
	    add_setlist_to_list(set->construct.sort.key, nr_set);
	}
    }
}

void convert_sort(tilmod, i)
    struct module *tilmod;
    int i;
{
    int j;
    int nr_fun;
    fun_tuple *fun;

    mod = tilmod;
    NSOR = mod->entries_table[SOR];
    nr_fun = mod->entries_table[FUN];

    if (Option_Debug) {
	fprintf(stderr, "converting sort: %d\n", i);
    }
    for (j = 1, fun = mod->fun; j <= nr_fun; j++) {
	fun++;
	if (fun->return_list.indlist->key == i)
	    make_fun_term(fun, j, i);
    }
}

void convert_set(tilmod, i)
    struct module *tilmod;
    int i;
{
    mod = tilmod;
    NSOR = mod->entries_table[SOR];

    if (Option_Debug) {
	fprintf(stderr, "converting set: %d\n", i);
    }
    make_set_term(&mod->set[i], i);
}
