#include <stdio.h>
#include <string.h>
#include <sys/wait.h>
#include <unistd.h> /* for unlink */
#include "psf_prototype.h"
#include "tiltype.h"
#include "readtil.h"
#include "prtilparts.h"
#include "prtilpsf.h"
#include "fieldex.h"
#include "tilutil.h"
#include "psf_fopen.h"
#include "env_variables.h"
#include "psf_malloc.h"

static char *mybasename PROTO_ARGS((char *));

struct module *mod = NULL;
extern char *filename;

int read_til_spec(input)
    char *input;
{
    psf_file pf;
    static suffix suffixes[] = {{TILSUFFIX, TILSUFFIX_DEFAULT}, {NULL, NULL}};

    mod = PSF_MALLOC(struct module);
    pf = psf_fopen(input, suffixes);
    filename = pf.name;
    mod->name = mybasename(input);
    if (read_module(mod, pf.fp)) {
	fclose(pf.fp);
	return (2);
    }
    fclose(pf.fp);
    return (0);
}

static char *mybasename(s)
    char *s;
{
    char *p, *q, *r;
    int n;

    n = strlen(s);
    p = &s[n];
    while (*p != '/' && p != s)
	p--;
    if (*p == '/')
	p++;
    n = strlen(p);
    q = &p[n];
    while (*q != '.' && q != p)
	q--;
    if (q != p)
	*q = '\0';
    r = psf_strdup(p);
    if (q != p)
	*q = '.';
    return (r);
}

struct module *get_til_module()
{
    return (mod);
}
